/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.type.table.OdfNameType;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:detective}.
 *
 */
public abstract class OdfDetectiveElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "detective" );

    /**
     * Create the instance of OdfDetectiveElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDetectiveElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:detective}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink table:highlighted-range}.
    *
    *@return   return  the element {@odfLink table:highlighted-range}
    */
    public OdfHighlightedRangeElement createHighlightedRangeElement()
    {
        OdfHighlightedRangeElement  nHighlightedRange = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHighlightedRangeElement.class);
        this.appendChild( nHighlightedRange);
        return  nHighlightedRange;
    }                   
               
    /**
    * Create child element {@odfLink table:operation}.
    *
    *@param name     the attribute's type is OdfNameType, see {@attributeName  table:name} at specification
    *@param index  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@return   return  the element {@odfLink table:operation}
    */
    public OdfOperationElement createOperationElement(OdfNameType   name, org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   index)
    {
        OdfOperationElement  nOperation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfOperationElement.class);
        nOperation.setName( name);
        nOperation.setIndex( index);
        this.appendChild( nOperation);
        return  nOperation;      
    }
    
}
