/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfSheetObjectType;
import org.odftoolkit.odfdom.dom.type.table.OdfAcceptanceStateType;

import org.odftoolkit.odfdom.dom.element.office.OdfChangeInfoElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:deletion}.
 *
 */
public abstract class OdfDeletionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "deletion" );

    /**
     * Create the instance of OdfDeletionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDeletionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:deletion}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDeletionElement}
     *
     *@param type  The mandatory attribute {@attributeName  table:type}" 
     *@param position  The mandatory attribute {@attributeName  table:position}" 
     *@param id  The mandatory attribute {@attributeName  table:id}" 
     *
     */
    public void init(OdfSheetObjectType type, Integer position, String id)
    {
        setType( type );
        setPosition( position );
        setId( id );
    }

    /**
     * Get value of attribute {@attributeName table:type}.
     *
     *@return return the attribute which type is OdfSheetObjectType
     */
    public OdfSheetObjectType getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "type" ) );
        return OdfSheetObjectType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:type}.
     *
     *@param  type    the attribute's type is OdfSheetObjectType
     */ 
     public void setType( OdfSheetObjectType type )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "type" ), type.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:position}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "position" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:position}.
     *
     *@param  position    the attribute's type is Integer
     */ 
     public void setPosition( Integer position )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "position" ), position.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:table}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getTable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:table}.
     *
     *@param  table    the attribute's type is Integer
     */ 
     public void setTable( Integer table )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table" ), table.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:multi-deletion-spanned}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getMultiDeletionSpanned()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "multi-deletion-spanned" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:multi-deletion-spanned}.
     *
     *@param  multiDeletionSpanned    the attribute's type is Integer
     */ 
     public void setMultiDeletionSpanned( Integer multiDeletionSpanned )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "multi-deletion-spanned" ), multiDeletionSpanned.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName table:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName table:acceptance-state}.
     *
     *@return return the attribute which type is OdfAcceptanceStateType
     */
    public OdfAcceptanceStateType getAcceptanceState()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "acceptance-state" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "pending";
        }

        return OdfAcceptanceStateType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:acceptance-state}.
     *
     *@param  acceptanceState    the attribute's type is OdfAcceptanceStateType
     */ 
     public void setAcceptanceState( OdfAcceptanceStateType acceptanceState )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "acceptance-state" ), acceptanceState.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:rejecting-change-id}.
     *
     *@return return the attribute which type is String
     */
    public String getRejectingChangeId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "rejecting-change-id" ) );
    }

    /**
     * Set value of attribute {@attributeName table:rejecting-change-id}.
     *
     *@param  rejectingChangeId    the attribute's type is String
     */ 
     public void setRejectingChangeId( String rejectingChangeId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "rejecting-change-id" ), rejectingChangeId );
    }

    /**
    * Create child element {@odfLink office:change-info}.
    *
    *@return   return  the element {@odfLink office:change-info}
    */
    public OdfChangeInfoElement createChangeInfoElement()
    {
        OdfChangeInfoElement  nChangeInfo = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChangeInfoElement.class);
        this.appendChild( nChangeInfo);
        return  nChangeInfo;
    }                   
               
    /**
    * Create child element {@odfLink table:dependencies}.
    *
    *@return   return  the element {@odfLink table:dependencies}
    */
    public OdfDependenciesElement createDependenciesElement()
    {
        OdfDependenciesElement  nDependencies = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDependenciesElement.class);
        this.appendChild( nDependencies);
        return  nDependencies;
    }                   
               
    /**
    * Create child element {@odfLink table:deletions}.
    *
    *@return   return  the element {@odfLink table:deletions}
    */
    public OdfDeletionsElement createDeletionsElement()
    {
        OdfDeletionsElement  nDeletions = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDeletionsElement.class);
        this.appendChild( nDeletions);
        return  nDeletions;
    }                   
               
    /**
    * Create child element {@odfLink table:cut-offs}.
    *
    *@return   return  the element {@odfLink table:cut-offs}
    */
    public OdfCutOffsElement createCutOffsElement()
    {
        OdfCutOffsElement  nCutOffs = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCutOffsElement.class);
        this.appendChild( nCutOffs);
        return  nCutOffs;
    }                   
               
}
