/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:database-source-table}.
 *
 */
public abstract class OdfDatabaseSourceTableElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "database-source-table" );

    /**
     * Create the instance of OdfDatabaseSourceTableElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDatabaseSourceTableElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:database-source-table}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDatabaseSourceTableElement}
     *
     *@param databaseName  The mandatory attribute {@attributeName  table:database-name}" 
     *@param databaseTableName  The mandatory attribute {@attributeName  table:database-table-name}" 
     *
     */
    public void init(String databaseName, String databaseTableName)
    {
        setDatabaseName( databaseName );
        setDatabaseTableName( databaseTableName );
    }

    /**
     * Get value of attribute {@attributeName table:database-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDatabaseName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "database-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:database-name}.
     *
     *@param  databaseName    the attribute's type is String
     */ 
     public void setDatabaseName( String databaseName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "database-name" ), databaseName );
    }

    /**
     * Get value of attribute {@attributeName table:database-table-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDatabaseTableName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "database-table-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:database-table-name}.
     *
     *@param  databaseTableName    the attribute's type is String
     */ 
     public void setDatabaseTableName( String databaseTableName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "database-table-name" ), databaseTableName );
    }

}
