/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:database-source-sql}.
 *
 */
public abstract class OdfDatabaseSourceSqlElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "database-source-sql" );

    /**
     * Create the instance of OdfDatabaseSourceSqlElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDatabaseSourceSqlElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:database-source-sql}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDatabaseSourceSqlElement}
     *
     *@param databaseName  The mandatory attribute {@attributeName  table:database-name}" 
     *@param sqlStatement  The mandatory attribute {@attributeName  table:sql-statement}" 
     *
     */
    public void init(String databaseName, String sqlStatement)
    {
        setDatabaseName( databaseName );
        setSqlStatement( sqlStatement );
    }

    /**
     * Get value of attribute {@attributeName table:database-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDatabaseName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "database-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:database-name}.
     *
     *@param  databaseName    the attribute's type is String
     */ 
     public void setDatabaseName( String databaseName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "database-name" ), databaseName );
    }

    /**
     * Get value of attribute {@attributeName table:sql-statement}.
     *
     *@return return the attribute which type is String
     */
    public String getSqlStatement()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "sql-statement" ) );
    }

    /**
     * Set value of attribute {@attributeName table:sql-statement}.
     *
     *@param  sqlStatement    the attribute's type is String
     */ 
     public void setSqlStatement( String sqlStatement )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "sql-statement" ), sqlStatement );
    }

    /**
     * Get value of attribute {@attributeName table:parse-sql-statement}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getParseSqlStatement()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "parse-sql-statement" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:parse-sql-statement}.
     *
     *@param  isParseSqlStatement    the attribute's type is OdfBoolean
     */ 
     public void setParseSqlStatement( OdfBoolean isParseSqlStatement )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "parse-sql-statement" ), isParseSqlStatement.toString() );
    }

}
