/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.table.OdfOrientationType;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:database-range}.
 *
 */
public abstract class OdfDatabaseRangeElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "database-range" );

    /**
     * Create the instance of OdfDatabaseRangeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDatabaseRangeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:database-range}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDatabaseRangeElement}
     *
     *@param targetRangeAddress  The mandatory attribute {@attributeName  table:target-range-address}" 
     *
     */
    public void init(OdfCellRangeAddress targetRangeAddress)
    {
        setTargetRangeAddress( targetRangeAddress );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:is-selection}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIsSelection()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-selection" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:is-selection}.
     *
     *@param  isIsSelection    the attribute's type is OdfBoolean
     */ 
     public void setIsSelection( OdfBoolean isIsSelection )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-selection" ), isIsSelection.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:on-update-keep-styles}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getOnUpdateKeepStyles()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "on-update-keep-styles" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:on-update-keep-styles}.
     *
     *@param  isOnUpdateKeepStyles    the attribute's type is OdfBoolean
     */ 
     public void setOnUpdateKeepStyles( OdfBoolean isOnUpdateKeepStyles )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "on-update-keep-styles" ), isOnUpdateKeepStyles.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:on-update-keep-size}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getOnUpdateKeepSize()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "on-update-keep-size" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:on-update-keep-size}.
     *
     *@param  isOnUpdateKeepSize    the attribute's type is OdfBoolean
     */ 
     public void setOnUpdateKeepSize( OdfBoolean isOnUpdateKeepSize )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "on-update-keep-size" ), isOnUpdateKeepSize.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:has-persistent-data}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getHasPersistentData()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "has-persistent-data" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:has-persistent-data}.
     *
     *@param  isHasPersistentData    the attribute's type is OdfBoolean
     */ 
     public void setHasPersistentData( OdfBoolean isHasPersistentData )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "has-persistent-data" ), isHasPersistentData.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:orientation}.
     *
     *@return return the attribute which type is OdfOrientationType
     */
    public OdfOrientationType getOrientation()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "orientation" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "row";
        }

        return OdfOrientationType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:orientation}.
     *
     *@param  orientation    the attribute's type is OdfOrientationType
     */ 
     public void setOrientation( OdfOrientationType orientation )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "orientation" ), orientation.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:contains-header}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getContainsHeader()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "contains-header" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:contains-header}.
     *
     *@param  isContainsHeader    the attribute's type is OdfBoolean
     */ 
     public void setContainsHeader( OdfBoolean isContainsHeader )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "contains-header" ), isContainsHeader.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:display-filter-buttons}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisplayFilterButtons()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-filter-buttons" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:display-filter-buttons}.
     *
     *@param  isDisplayFilterButtons    the attribute's type is OdfBoolean
     */ 
     public void setDisplayFilterButtons( OdfBoolean isDisplayFilterButtons )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-filter-buttons" ), isDisplayFilterButtons.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:target-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getTargetRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:target-range-address}.
     *
     *@param  targetRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setTargetRangeAddress( OdfCellRangeAddress targetRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ), targetRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:refresh-delay}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getRefreshDelay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "refresh-delay" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:refresh-delay}.
     *
     *@param  isRefreshDelay    the attribute's type is OdfBoolean
     */ 
     public void setRefreshDelay( OdfBoolean isRefreshDelay )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "refresh-delay" ), isRefreshDelay.toString() );
    }

    /**
    * Create child element {@odfLink table:database-source-sql}.
    *
    *@param databaseName String   
    *@param sqlStatement String   
    *@return   return  the element {@odfLink table:database-source-sql}
    */
    public OdfDatabaseSourceSqlElement createDatabaseSourceSqlElement(String   databaseName, String   sqlStatement)
    {
        OdfDatabaseSourceSqlElement  nDatabaseSourceSql = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceSqlElement.class);
        nDatabaseSourceSql.setDatabaseName( databaseName);
        nDatabaseSourceSql.setSqlStatement( sqlStatement);
        this.appendChild( nDatabaseSourceSql);
        return  nDatabaseSourceSql;      
    }
    
    /**
    * Create child element {@odfLink table:database-source-query}.
    *
    *@param databaseName String   
    *@param queryName String   
    *@return   return  the element {@odfLink table:database-source-query}
    */
    public OdfDatabaseSourceQueryElement createDatabaseSourceQueryElement(String   databaseName, String   queryName)
    {
        OdfDatabaseSourceQueryElement  nDatabaseSourceQuery = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceQueryElement.class);
        nDatabaseSourceQuery.setDatabaseName( databaseName);
        nDatabaseSourceQuery.setQueryName( queryName);
        this.appendChild( nDatabaseSourceQuery);
        return  nDatabaseSourceQuery;      
    }
    
    /**
    * Create child element {@odfLink table:database-source-table}.
    *
    *@param databaseName String   
    *@param databaseTableName String   
    *@return   return  the element {@odfLink table:database-source-table}
    */
    public OdfDatabaseSourceTableElement createDatabaseSourceTableElement(String   databaseName, String   databaseTableName)
    {
        OdfDatabaseSourceTableElement  nDatabaseSourceTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceTableElement.class);
        nDatabaseSourceTable.setDatabaseName( databaseName);
        nDatabaseSourceTable.setDatabaseTableName( databaseTableName);
        this.appendChild( nDatabaseSourceTable);
        return  nDatabaseSourceTable;      
    }
    
    /**
    * Create child element {@odfLink table:filter}.
    *
    *@return   return  the element {@odfLink table:filter}
    */
    public OdfFilterElement createFilterElement()
    {
        OdfFilterElement  nFilter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFilterElement.class);
        this.appendChild( nFilter);
        return  nFilter;
    }                   
               
    /**
    * Create child element {@odfLink table:sort}.
    *
    *@return   return  the element {@odfLink table:sort}
    */
    public OdfSortElement createSortElement()
    {
        OdfSortElement  nSort = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSortElement.class);
        this.appendChild( nSort);
        return  nSort;
    }                   
               
    /**
    * Create child element {@odfLink table:subtotal-rules}.
    *
    *@return   return  the element {@odfLink table:subtotal-rules}
    */
    public OdfSubtotalRulesElement createSubtotalRulesElement()
    {
        OdfSubtotalRulesElement  nSubtotalRules = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSubtotalRulesElement.class);
        this.appendChild( nSubtotalRules);
        return  nSubtotalRules;
    }                   
               
}
