/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfGrandTotalType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;

import org.odftoolkit.odfdom.dom.type.table.OdfOrientationType;
import org.odftoolkit.odfdom.dom.type.table.OdfOrientationType;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-table}.
 *
 */
public abstract class OdfDataPilotTableElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-table" );

    /**
     * Create the instance of OdfDataPilotTableElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotTableElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-table}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataPilotTableElement}
     *
     *@param name  The mandatory attribute {@attributeName  table:name}" 
     *@param targetRangeAddress  The mandatory attribute {@attributeName  table:target-range-address}" 
     *
     */
    public void init(String name, OdfCellRangeAddress targetRangeAddress)
    {
        setName( name );
        setTargetRangeAddress( targetRangeAddress );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:application-data}.
     *
     *@return return the attribute which type is String
     */
    public String getApplicationData()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "application-data" ) );
    }

    /**
     * Set value of attribute {@attributeName table:application-data}.
     *
     *@param  applicationData    the attribute's type is String
     */ 
     public void setApplicationData( String applicationData )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "application-data" ), applicationData );
    }

    /**
     * Get value of attribute {@attributeName table:grand-total}.
     *
     *@return return the attribute which type is OdfGrandTotalType
     */
    public OdfGrandTotalType getGrandTotal()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "grand-total" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "both";
        }

        return OdfGrandTotalType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:grand-total}.
     *
     *@param  grandTotal    the attribute's type is OdfGrandTotalType
     */ 
     public void setGrandTotal( OdfGrandTotalType grandTotal )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "grand-total" ), grandTotal.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:ignore-empty-rows}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIgnoreEmptyRows()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "ignore-empty-rows" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:ignore-empty-rows}.
     *
     *@param  isIgnoreEmptyRows    the attribute's type is OdfBoolean
     */ 
     public void setIgnoreEmptyRows( OdfBoolean isIgnoreEmptyRows )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "ignore-empty-rows" ), isIgnoreEmptyRows.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:identify-categories}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getIdentifyCategories()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "identify-categories" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:identify-categories}.
     *
     *@param  isIdentifyCategories    the attribute's type is OdfBoolean
     */ 
     public void setIdentifyCategories( OdfBoolean isIdentifyCategories )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "identify-categories" ), isIdentifyCategories.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:target-range-address}.
     *
     *@return return the attribute which type is OdfCellRangeAddress
     */
    public OdfCellRangeAddress getTargetRangeAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ) );
        return OdfCellRangeAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:target-range-address}.
     *
     *@param  targetRangeAddress    the attribute's type is OdfCellRangeAddress
     */ 
     public void setTargetRangeAddress( OdfCellRangeAddress targetRangeAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-range-address" ), targetRangeAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:buttons}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getButtons()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "buttons" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:buttons}.
     *
     *@param  buttons    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setButtons( OdfCellRangeAddressList buttons )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "buttons" ), buttons.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:show-filter-button}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getShowFilterButton()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "show-filter-button" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:show-filter-button}.
     *
     *@param  isShowFilterButton    the attribute's type is OdfBoolean
     */ 
     public void setShowFilterButton( OdfBoolean isShowFilterButton )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "show-filter-button" ), isShowFilterButton.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:drill-down-on-double-click}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDrillDownOnDoubleClick()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "drill-down-on-double-click" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:drill-down-on-double-click}.
     *
     *@param  isDrillDownOnDoubleClick    the attribute's type is OdfBoolean
     */ 
     public void setDrillDownOnDoubleClick( OdfBoolean isDrillDownOnDoubleClick )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "drill-down-on-double-click" ), isDrillDownOnDoubleClick.toString() );
    }

    /**
    * Create child element {@odfLink table:database-source-sql}.
    *
    *@param databaseName String   
    *@param sqlStatement String   
    *@return   return  the element {@odfLink table:database-source-sql}
    */
    public OdfDatabaseSourceSqlElement createDatabaseSourceSqlElement(String   databaseName, String   sqlStatement)
    {
        OdfDatabaseSourceSqlElement  nDatabaseSourceSql = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceSqlElement.class);
        nDatabaseSourceSql.setDatabaseName( databaseName);
        nDatabaseSourceSql.setSqlStatement( sqlStatement);
        this.appendChild( nDatabaseSourceSql);
        return  nDatabaseSourceSql;      
    }
    
    /**
    * Create child element {@odfLink table:database-source-query}.
    *
    *@param databaseName String   
    *@param queryName String   
    *@return   return  the element {@odfLink table:database-source-query}
    */
    public OdfDatabaseSourceQueryElement createDatabaseSourceQueryElement(String   databaseName, String   queryName)
    {
        OdfDatabaseSourceQueryElement  nDatabaseSourceQuery = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceQueryElement.class);
        nDatabaseSourceQuery.setDatabaseName( databaseName);
        nDatabaseSourceQuery.setQueryName( queryName);
        this.appendChild( nDatabaseSourceQuery);
        return  nDatabaseSourceQuery;      
    }
    
    /**
    * Create child element {@odfLink table:database-source-table}.
    *
    *@param databaseName String   
    *@param databaseTableName String   
    *@return   return  the element {@odfLink table:database-source-table}
    */
    public OdfDatabaseSourceTableElement createDatabaseSourceTableElement(String   databaseName, String   databaseTableName)
    {
        OdfDatabaseSourceTableElement  nDatabaseSourceTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDatabaseSourceTableElement.class);
        nDatabaseSourceTable.setDatabaseName( databaseName);
        nDatabaseSourceTable.setDatabaseTableName( databaseTableName);
        this.appendChild( nDatabaseSourceTable);
        return  nDatabaseSourceTable;      
    }
    
    /**
    * Create child element {@odfLink table:source-service}.
    *
    *@param name String   
    *@param sourceName String   
    *@param objectName String   
    *@return   return  the element {@odfLink table:source-service}
    */
    public OdfSourceServiceElement createSourceServiceElement(String   name, String   sourceName, String   objectName)
    {
        OdfSourceServiceElement  nSourceService = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSourceServiceElement.class);
        nSourceService.setName( name);
        nSourceService.setSourceName( sourceName);
        nSourceService.setObjectName( objectName);
        this.appendChild( nSourceService);
        return  nSourceService;      
    }
    
    /**
    * Create child element {@odfLink table:source-cell-range}.
    *
    *@param cellRangeAddress  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress
    *@return   return  the element {@odfLink table:source-cell-range}
    */
    public OdfSourceCellRangeElement createSourceCellRangeElement(org.odftoolkit.odfdom.dom.type.OdfCellRangeAddress   cellRangeAddress)
    {
        OdfSourceCellRangeElement  nSourceCellRange = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSourceCellRangeElement.class);
        nSourceCellRange.setCellRangeAddress( cellRangeAddress);
        this.appendChild( nSourceCellRange);
        return  nSourceCellRange;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-field}.
    *
    *@param sourceFieldName String   
    *@param orientation     the attribute's type is OdfOrientationType, see {@attributeName  table:orientation} at specification
    *@return   return  the element {@odfLink table:data-pilot-field}
    */
    public OdfDataPilotFieldElement createDataPilotFieldElement(String   sourceFieldName, OdfOrientationType   orientation)
    {
        OdfDataPilotFieldElement  nDataPilotField = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotFieldElement.class);
        nDataPilotField.setSourceFieldName( sourceFieldName);
        nDataPilotField.setOrientation( orientation);
        this.appendChild( nDataPilotField);
        return  nDataPilotField;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-field}.
    *
    *@param orientation   the attribute's type is OdfOrientationType, see {@attributeName  table:orientation} at specification
    *@param selectedPage String   
    *@param sourceFieldName String   
    *@return   return  the element {@odfLink table:data-pilot-field}
    */
    public OdfDataPilotFieldElement createDataPilotFieldElement(OdfOrientationType   orientation, String   selectedPage, String   sourceFieldName)
    {
        OdfDataPilotFieldElement  nDataPilotField = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotFieldElement.class);
        nDataPilotField.setOrientation( orientation);
        nDataPilotField.setSelectedPage( selectedPage);
        nDataPilotField.setSourceFieldName( sourceFieldName);
        this.appendChild( nDataPilotField);
        return  nDataPilotField;      
    }
    
}
