/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfSortModeType;
import org.odftoolkit.odfdom.dom.type.table.OdfOrderType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-sort-info}.
 *
 */
public abstract class OdfDataPilotSortInfoElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-sort-info" );

    /**
     * Create the instance of OdfDataPilotSortInfoElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotSortInfoElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-sort-info}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataPilotSortInfoElement}
     *
     *@param sortMode  The mandatory attribute {@attributeName  table:sort-mode}" 
     *@param dataField  The mandatory attribute {@attributeName  table:data-field}" 
     *@param order  The mandatory attribute {@attributeName  table:order}" 
     *
     */
    public void init(OdfSortModeType sortMode, String dataField, OdfOrderType order)
    {
        setSortMode( sortMode );
        setDataField( dataField );
        setOrder( order );
    }

    /**
     * Get value of attribute {@attributeName table:sort-mode}.
     *
     *@return return the attribute which type is OdfSortModeType
     */
    public OdfSortModeType getSortMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "sort-mode" ) );
        return OdfSortModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:sort-mode}.
     *
     *@param  sortMode    the attribute's type is OdfSortModeType
     */ 
     public void setSortMode( OdfSortModeType sortMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "sort-mode" ), sortMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:data-field}.
     *
     *@return return the attribute which type is String
     */
    public String getDataField()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-field" ) );
    }

    /**
     * Set value of attribute {@attributeName table:data-field}.
     *
     *@param  dataField    the attribute's type is String
     */ 
     public void setDataField( String dataField )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-field" ), dataField );
    }

    /**
     * Get value of attribute {@attributeName table:order}.
     *
     *@return return the attribute which type is OdfOrderType
     */
    public OdfOrderType getOrder()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "order" ) );
        return OdfOrderType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:order}.
     *
     *@param  order    the attribute's type is OdfOrderType
     */ 
     public void setOrder( OdfOrderType order )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "order" ), order.toString() );
    }

}
