/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

import org.odftoolkit.odfdom.dom.type.table.OdfDisplayMemberModeType;
import org.odftoolkit.odfdom.dom.type.table.OdfDisplayMemberModeType;
import org.odftoolkit.odfdom.dom.type.table.OdfOrderType;
import org.odftoolkit.odfdom.dom.type.table.OdfSortModeType;
import org.odftoolkit.odfdom.dom.type.table.OdfLayoutModeType;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-level}.
 *
 */
public abstract class OdfDataPilotLevelElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-level" );

    /**
     * Create the instance of OdfDataPilotLevelElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotLevelElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-level}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:show-empty}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getShowEmpty()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "show-empty" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:show-empty}.
     *
     *@param  isShowEmpty    the attribute's type is OdfBoolean
     */ 
     public void setShowEmpty( OdfBoolean isShowEmpty )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "show-empty" ), isShowEmpty.toString() );
    }

    /**
    * Create child element {@odfLink table:data-pilot-subtotals}.
    *
    *@return   return  the element {@odfLink table:data-pilot-subtotals}
    */
    public OdfDataPilotSubtotalsElement createDataPilotSubtotalsElement()
    {
        OdfDataPilotSubtotalsElement  nDataPilotSubtotals = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotSubtotalsElement.class);
        this.appendChild( nDataPilotSubtotals);
        return  nDataPilotSubtotals;
    }                   
               
    /**
    * Create child element {@odfLink table:data-pilot-members}.
    *
    *@return   return  the element {@odfLink table:data-pilot-members}
    */
    public OdfDataPilotMembersElement createDataPilotMembersElement()
    {
        OdfDataPilotMembersElement  nDataPilotMembers = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotMembersElement.class);
        this.appendChild( nDataPilotMembers);
        return  nDataPilotMembers;
    }                   
               
    /**
    * Create child element {@odfLink table:data-pilot-display-info}.
    *
    *@param enabled  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param dataField String   
    *@param memberCount  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@param displayMemberMode     the attribute's type is OdfDisplayMemberModeType, see {@attributeName  table:display-member-mode} at specification
    *@return   return  the element {@odfLink table:data-pilot-display-info}
    */
    public OdfDataPilotDisplayInfoElement createDataPilotDisplayInfoElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   enabled, String   dataField, org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   memberCount, OdfDisplayMemberModeType   displayMemberMode)
    {
        OdfDataPilotDisplayInfoElement  nDataPilotDisplayInfo = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotDisplayInfoElement.class);
        nDataPilotDisplayInfo.setEnabled( enabled);
        nDataPilotDisplayInfo.setDataField( dataField);
        nDataPilotDisplayInfo.setMemberCount( memberCount);
        nDataPilotDisplayInfo.setDisplayMemberMode( displayMemberMode);
        this.appendChild( nDataPilotDisplayInfo);
        return  nDataPilotDisplayInfo;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-sort-info}.
    *
    *@param order     the attribute's type is OdfOrderType, see {@attributeName  table:order} at specification
    *@param sortMode     the attribute's type is OdfSortModeType, see {@attributeName  table:sort-mode} at specification
    *@return   return  the element {@odfLink table:data-pilot-sort-info}
    */
    public OdfDataPilotSortInfoElement createDataPilotSortInfoElement(OdfOrderType   order, OdfSortModeType   sortMode)
    {
        OdfDataPilotSortInfoElement  nDataPilotSortInfo = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotSortInfoElement.class);
        nDataPilotSortInfo.setOrder( order);
        nDataPilotSortInfo.setSortMode( sortMode);
        this.appendChild( nDataPilotSortInfo);
        return  nDataPilotSortInfo;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-sort-info}.
    *
    *@param sortMode   the attribute's type is OdfSortModeType, see {@attributeName  table:sort-mode} at specification
    *@param dataField String   
    *@param order     the attribute's type is OdfOrderType, see {@attributeName  table:order} at specification
    *@return   return  the element {@odfLink table:data-pilot-sort-info}
    */
    public OdfDataPilotSortInfoElement createDataPilotSortInfoElement(OdfSortModeType   sortMode, String   dataField, OdfOrderType   order)
    {
        OdfDataPilotSortInfoElement  nDataPilotSortInfo = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotSortInfoElement.class);
        nDataPilotSortInfo.setSortMode( sortMode);
        nDataPilotSortInfo.setDataField( dataField);
        nDataPilotSortInfo.setOrder( order);
        this.appendChild( nDataPilotSortInfo);
        return  nDataPilotSortInfo;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-layout-info}.
    *
    *@param layoutMode     the attribute's type is OdfLayoutModeType, see {@attributeName  table:layout-mode} at specification
    *@param addEmptyLines  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@return   return  the element {@odfLink table:data-pilot-layout-info}
    */
    public OdfDataPilotLayoutInfoElement createDataPilotLayoutInfoElement(OdfLayoutModeType   layoutMode, org.odftoolkit.odfdom.dom.type.OdfBoolean   addEmptyLines)
    {
        OdfDataPilotLayoutInfoElement  nDataPilotLayoutInfo = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotLayoutInfoElement.class);
        nDataPilotLayoutInfo.setLayoutMode( layoutMode);
        nDataPilotLayoutInfo.setAddEmptyLines( addEmptyLines);
        this.appendChild( nDataPilotLayoutInfo);
        return  nDataPilotLayoutInfo;      
    }
    
}
