/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfLayoutModeType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-layout-info}.
 *
 */
public abstract class OdfDataPilotLayoutInfoElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-layout-info" );

    /**
     * Create the instance of OdfDataPilotLayoutInfoElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotLayoutInfoElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-layout-info}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataPilotLayoutInfoElement}
     *
     *@param layoutMode  The mandatory attribute {@attributeName  table:layout-mode}" 
     *@param addEmptyLines  The mandatory attribute {@attributeName  table:add-empty-lines}" 
     *
     */
    public void init(OdfLayoutModeType layoutMode, OdfBoolean addEmptyLines)
    {
        setLayoutMode( layoutMode );
        setAddEmptyLines( addEmptyLines );
    }

    /**
     * Get value of attribute {@attributeName table:layout-mode}.
     *
     *@return return the attribute which type is OdfLayoutModeType
     */
    public OdfLayoutModeType getLayoutMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "layout-mode" ) );
        return OdfLayoutModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:layout-mode}.
     *
     *@param  layoutMode    the attribute's type is OdfLayoutModeType
     */ 
     public void setLayoutMode( OdfLayoutModeType layoutMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "layout-mode" ), layoutMode.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:add-empty-lines}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAddEmptyLines()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "add-empty-lines" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:add-empty-lines}.
     *
     *@param  isAddEmptyLines    the attribute's type is OdfBoolean
     */ 
     public void setAddEmptyLines( OdfBoolean isAddEmptyLines )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "add-empty-lines" ), isAddEmptyLines.toString() );
    }

}
