/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import javax.xml.datatype.XMLGregorianCalendar;
import org.odftoolkit.odfdom.dom.type.OdfDate;
import org.odftoolkit.odfdom.dom.type.table.OdfGroupedByType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-groups}.
 *
 */
public abstract class OdfDataPilotGroupsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-groups" );

    /**
     * Create the instance of OdfDataPilotGroupsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotGroupsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-groups}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataPilotGroupsElement}
     *
     *@param sourceFieldName  The mandatory attribute {@attributeName  table:source-field-name}" 
     *@param dateStart  The mandatory attribute {@attributeName  table:date-start}" 
     *@param start  The mandatory attribute {@attributeName  table:start}" 
     *@param dateEnd  The mandatory attribute {@attributeName  table:date-end}" 
     *@param end  The mandatory attribute {@attributeName  table:end}" 
     *@param step  The mandatory attribute {@attributeName  table:step}" 
     *@param groupedBy  The mandatory attribute {@attributeName  table:grouped-by}" 
     *
     */
    public void init(String sourceFieldName, OdfDate dateStart, Double start, OdfDate dateEnd, Double end, Double step, OdfGroupedByType groupedBy)
    {
        setSourceFieldName( sourceFieldName );
        setDateStart( dateStart );
        setStart( start );
        setDateEnd( dateEnd );
        setEnd( end );
        setStep( step );
        setGroupedBy( groupedBy );
    }

    /**
     * Get value of attribute {@attributeName table:source-field-name}.
     *
     *@return return the attribute which type is String
     */
    public String getSourceFieldName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-field-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:source-field-name}.
     *
     *@param  sourceFieldName    the attribute's type is String
     */ 
     public void setSourceFieldName( String sourceFieldName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-field-name" ), sourceFieldName );
    }

    /**
     * Get value of attribute {@attributeName table:date-start}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getDateStart()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "date-start" ) );
        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:date-start}.
     *
     *@param  dateStart    the attribute's type is OdfDate
     */ 
     public void setDateStart( OdfDate dateStart )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "date-start" ), dateStart.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:start}.
     *
     *@return return the attribute which type is Double
     */
    public Double getStart()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:start}.
     *
     *@param  start    the attribute's type is Double
     */ 
     public void setStart( Double start )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "start" ), start.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:date-end}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getDateEnd()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "date-end" ) );
        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:date-end}.
     *
     *@param  dateEnd    the attribute's type is OdfDate
     */ 
     public void setDateEnd( OdfDate dateEnd )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "date-end" ), dateEnd.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:end}.
     *
     *@return return the attribute which type is Double
     */
    public Double getEnd()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:end}.
     *
     *@param  end    the attribute's type is Double
     */ 
     public void setEnd( Double end )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "end" ), end.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:step}.
     *
     *@return return the attribute which type is Double
     */
    public Double getStep()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "step" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:step}.
     *
     *@param  step    the attribute's type is Double
     */ 
     public void setStep( Double step )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "step" ), step.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:grouped-by}.
     *
     *@return return the attribute which type is OdfGroupedByType
     */
    public OdfGroupedByType getGroupedBy()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "grouped-by" ) );
        return OdfGroupedByType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:grouped-by}.
     *
     *@param  groupedBy    the attribute's type is OdfGroupedByType
     */ 
     public void setGroupedBy( OdfGroupedByType groupedBy )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "grouped-by" ), groupedBy.toString() );
    }

    /**
    * Create child element {@odfLink table:data-pilot-group}.
    *
    *@param name String   
    *@return   return  the element {@odfLink table:data-pilot-group}
    */
    public OdfDataPilotGroupElement createDataPilotGroupElement(String   name)
    {
        OdfDataPilotGroupElement  nDataPilotGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotGroupElement.class);
        nDataPilotGroup.setName( name);
        this.appendChild( nDataPilotGroup);
        return  nDataPilotGroup;      
    }
    
}
