/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfMemberType;
import org.odftoolkit.odfdom.dom.type.table.OdfFieldReferenceType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-field-reference}.
 *
 */
public abstract class OdfDataPilotFieldReferenceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-field-reference" );

    /**
     * Create the instance of OdfDataPilotFieldReferenceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotFieldReferenceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-field-reference}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataPilotFieldReferenceElement}
     *
     *@param fieldName  The mandatory attribute {@attributeName  table:field-name}" 
     *@param memberType  The mandatory attribute {@attributeName  table:member-type}" 
     *@param memberName  The mandatory attribute {@attributeName  table:member-name}" 
     *@param type  The mandatory attribute {@attributeName  table:type}" 
     *
     */
    public void init(String fieldName, OdfMemberType memberType, String memberName, OdfFieldReferenceType type)
    {
        setFieldName( fieldName );
        setMemberType( memberType );
        setMemberName( memberName );
        setType( type );
    }

    /**
     * Get value of attribute {@attributeName table:field-name}.
     *
     *@return return the attribute which type is String
     */
    public String getFieldName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "field-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:field-name}.
     *
     *@param  fieldName    the attribute's type is String
     */ 
     public void setFieldName( String fieldName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "field-name" ), fieldName );
    }

    /**
     * Get value of attribute {@attributeName table:member-type}.
     *
     *@return return the attribute which type is OdfMemberType
     */
    public OdfMemberType getMemberType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "member-type" ) );
        return OdfMemberType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:member-type}.
     *
     *@param  memberType    the attribute's type is OdfMemberType
     */ 
     public void setMemberType( OdfMemberType memberType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "member-type" ), memberType.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:member-name}.
     *
     *@return return the attribute which type is String
     */
    public String getMemberName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "member-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:member-name}.
     *
     *@param  memberName    the attribute's type is String
     */ 
     public void setMemberName( String memberName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "member-name" ), memberName );
    }

    /**
     * Get value of attribute {@attributeName table:type}.
     *
     *@return return the attribute which type is OdfFieldReferenceType
     */
    public OdfFieldReferenceType getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "type" ) );
        return OdfFieldReferenceType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:type}.
     *
     *@param  type    the attribute's type is OdfFieldReferenceType
     */ 
     public void setType( OdfFieldReferenceType type )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "type" ), type.toString() );
    }

}
