/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfOrientationType;

import org.odftoolkit.odfdom.dom.type.table.OdfFieldReferenceType;
import org.odftoolkit.odfdom.dom.type.table.OdfMemberType;
import org.odftoolkit.odfdom.dom.type.table.OdfFieldReferenceType;
import org.odftoolkit.odfdom.dom.type.table.OdfGroupedByType;
import javax.xml.datatype.XMLGregorianCalendar;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-field}.
 *
 */
public abstract class OdfDataPilotFieldElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-field" );

    /**
     * Create the instance of OdfDataPilotFieldElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotFieldElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-field}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataPilotFieldElement}
     *
     *@param sourceFieldName  The mandatory attribute {@attributeName  table:source-field-name}" 
     *@param orientation  The mandatory attribute {@attributeName  table:orientation}" 
     *@param selectedPage  The mandatory attribute {@attributeName  table:selected-page}" 
     *
     */
    public void init(String sourceFieldName, OdfOrientationType orientation, String selectedPage)
    {
        setSourceFieldName( sourceFieldName );
        setOrientation( orientation );
        setSelectedPage( selectedPage );
    }

    /**
     * Get value of attribute {@attributeName table:source-field-name}.
     *
     *@return return the attribute which type is String
     */
    public String getSourceFieldName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-field-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:source-field-name}.
     *
     *@param  sourceFieldName    the attribute's type is String
     */ 
     public void setSourceFieldName( String sourceFieldName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-field-name" ), sourceFieldName );
    }

    /**
     * Get value of attribute {@attributeName table:orientation}.
     *
     *@return return the attribute which type is OdfOrientationType
     */
    public OdfOrientationType getOrientation()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "orientation" ) );
        return OdfOrientationType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:orientation}.
     *
     *@param  orientation    the attribute's type is OdfOrientationType
     */ 
     public void setOrientation( OdfOrientationType orientation )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "orientation" ), orientation.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:selected-page}.
     *
     *@return return the attribute which type is String
     */
    public String getSelectedPage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "selected-page" ) );
    }

    /**
     * Set value of attribute {@attributeName table:selected-page}.
     *
     *@param  selectedPage    the attribute's type is String
     */ 
     public void setSelectedPage( String selectedPage )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "selected-page" ), selectedPage );
    }

    /**
     * Get value of attribute {@attributeName table:is-data-layout-field}.
     *
     *@return return the attribute which type is String
     */
    public String getIsDataLayoutField()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-data-layout-field" ) );
    }

    /**
     * Set value of attribute {@attributeName table:is-data-layout-field}.
     *
     *@param  isDataLayoutField    the attribute's type is String
     */ 
     public void setIsDataLayoutField( String isDataLayoutField )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "is-data-layout-field" ), isDataLayoutField );
    }

    /**
     * Get value of attribute {@attributeName table:function}.
     *
     *@return return the attribute which type is String
     */
    public String getFunction()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "function" ) );
    }

    /**
     * Set value of attribute {@attributeName table:function}.
     *
     *@param  function    the attribute's type is String
     */ 
     public void setFunction( String function )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "function" ), function );
    }

    /**
     * Get value of attribute {@attributeName table:used-hierarchy}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getUsedHierarchy()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "used-hierarchy" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "-1";
        }

        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:used-hierarchy}.
     *
     *@param  usedHierarchy    the attribute's type is Integer
     */ 
     public void setUsedHierarchy( Integer usedHierarchy )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "used-hierarchy" ), usedHierarchy.toString() );
    }

    /**
    * Create child element {@odfLink table:data-pilot-level}.
    *
    *@return   return  the element {@odfLink table:data-pilot-level}
    */
    public OdfDataPilotLevelElement createDataPilotLevelElement()
    {
        OdfDataPilotLevelElement  nDataPilotLevel = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotLevelElement.class);
        this.appendChild( nDataPilotLevel);
        return  nDataPilotLevel;
    }                   
               
    /**
    * Create child element {@odfLink table:data-pilot-field-reference}.
    *
    *@param fieldName String   
    *@param type     the attribute's type is OdfFieldReferenceType, see {@attributeName  table:field-reference} at specification
    *@param memberType   the attribute's type is OdfMemberType, see {@attributeName  table:member-type} at specification
    *@return   return  the element {@odfLink table:data-pilot-field-reference}
    */
    public OdfDataPilotFieldReferenceElement createDataPilotFieldReferenceElement(String   fieldName, OdfFieldReferenceType   type, OdfMemberType   memberType)
    {
        OdfDataPilotFieldReferenceElement  nDataPilotFieldReference = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotFieldReferenceElement.class);
        nDataPilotFieldReference.setFieldName( fieldName);
        nDataPilotFieldReference.setType( type);
        nDataPilotFieldReference.setMemberType( memberType);
        this.appendChild( nDataPilotFieldReference);
        return  nDataPilotFieldReference;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-field-reference}.
    *
    *@param memberType   the attribute's type is OdfMemberType, see {@attributeName  table:member-type} at specification
    *@param memberName String   
    *@param fieldName String   
    *@param type     the attribute's type is OdfFieldReferenceType, see {@attributeName  table:field-reference} at specification
    *@return   return  the element {@odfLink table:data-pilot-field-reference}
    */
    public OdfDataPilotFieldReferenceElement createDataPilotFieldReferenceElement(OdfMemberType   memberType, String   memberName, String   fieldName, OdfFieldReferenceType   type)
    {
        OdfDataPilotFieldReferenceElement  nDataPilotFieldReference = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotFieldReferenceElement.class);
        nDataPilotFieldReference.setMemberType( memberType);
        nDataPilotFieldReference.setMemberName( memberName);
        nDataPilotFieldReference.setFieldName( fieldName);
        nDataPilotFieldReference.setType( type);
        this.appendChild( nDataPilotFieldReference);
        return  nDataPilotFieldReference;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-groups}.
    *
    *@param sourceFieldName String   
    *@param step Double   
    *@param groupedBy     the attribute's type is OdfGroupedByType, see {@attributeName  table:grouped-by} at specification
    *@param dateStart    the attribute's type is XMLGregorianCalendar
    *@return   return  the element {@odfLink table:data-pilot-groups}
    */
    public OdfDataPilotGroupsElement createDataPilotGroupsElement(String   sourceFieldName, Double   step, OdfGroupedByType   groupedBy, org.odftoolkit.odfdom.dom.type.OdfDate   dateStart)
    {
        OdfDataPilotGroupsElement  nDataPilotGroups = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotGroupsElement.class);
        nDataPilotGroups.setSourceFieldName( sourceFieldName);
        nDataPilotGroups.setStep( step);
        nDataPilotGroups.setGroupedBy( groupedBy);
        nDataPilotGroups.setDateStart( dateStart);
        this.appendChild( nDataPilotGroups);
        return  nDataPilotGroups;      
    }
    
    /**
    * Create child element {@odfLink table:data-pilot-groups}.
    *
    *@param sourceFieldName String   
    *@param step Double   
    *@param groupedBy     the attribute's type is OdfGroupedByType, see {@attributeName  table:grouped-by} at specification
    *@param start Double   
    *@return   return  the element {@odfLink table:data-pilot-groups}
    */
    public OdfDataPilotGroupsElement createDataPilotGroupsElement(String   sourceFieldName, Double   step, OdfGroupedByType   groupedBy, Double   start)
    {
        OdfDataPilotGroupsElement  nDataPilotGroups = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDataPilotGroupsElement.class);
        nDataPilotGroups.setSourceFieldName( sourceFieldName);
        nDataPilotGroups.setStep( step);
        nDataPilotGroups.setGroupedBy( groupedBy);
        nDataPilotGroups.setStart( start);
        this.appendChild( nDataPilotGroups);
        return  nDataPilotGroups;      
    }
    
}
