/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger;
import org.odftoolkit.odfdom.dom.type.table.OdfDisplayMemberModeType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:data-pilot-display-info}.
 *
 */
public abstract class OdfDataPilotDisplayInfoElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "data-pilot-display-info" );

    /**
     * Create the instance of OdfDataPilotDisplayInfoElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDataPilotDisplayInfoElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:data-pilot-display-info}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfDataPilotDisplayInfoElement}
     *
     *@param enabled  The mandatory attribute {@attributeName  table:enabled}" 
     *@param dataField  The mandatory attribute {@attributeName  table:data-field}" 
     *@param memberCount  The mandatory attribute {@attributeName  table:member-count}" 
     *@param displayMemberMode  The mandatory attribute {@attributeName  table:display-member-mode}" 
     *
     */
    public void init(OdfBoolean enabled, String dataField, OdfNonNegativeInteger memberCount, OdfDisplayMemberModeType displayMemberMode)
    {
        setEnabled( enabled );
        setDataField( dataField );
        setMemberCount( memberCount );
        setDisplayMemberMode( displayMemberMode );
    }

    /**
     * Get value of attribute {@attributeName table:enabled}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getEnabled()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "enabled" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:enabled}.
     *
     *@param  isEnabled    the attribute's type is OdfBoolean
     */ 
     public void setEnabled( OdfBoolean isEnabled )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "enabled" ), isEnabled.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:data-field}.
     *
     *@return return the attribute which type is String
     */
    public String getDataField()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-field" ) );
    }

    /**
     * Set value of attribute {@attributeName table:data-field}.
     *
     *@param  dataField    the attribute's type is String
     */ 
     public void setDataField( String dataField )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "data-field" ), dataField );
    }

    /**
     * Get value of attribute {@attributeName table:member-count}.
     *
     *@return return the attribute which type is OdfNonNegativeInteger
     */
    public OdfNonNegativeInteger getMemberCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "member-count" ) );
        return OdfNonNegativeInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:member-count}.
     *
     *@param  memberCount    the attribute's type is OdfNonNegativeInteger
     */ 
     public void setMemberCount( OdfNonNegativeInteger memberCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "member-count" ), memberCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:display-member-mode}.
     *
     *@return return the attribute which type is OdfDisplayMemberModeType
     */
    public OdfDisplayMemberModeType getDisplayMemberMode()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-member-mode" ) );
        return OdfDisplayMemberModeType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:display-member-mode}.
     *
     *@param  displayMemberMode    the attribute's type is OdfDisplayMemberModeType
     */ 
     public void setDisplayMemberMode( OdfDisplayMemberModeType displayMemberMode )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-member-mode" ), displayMemberMode.toString() );
    }

}
