/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:cut-offs}.
 *
 */
public abstract class OdfCutOffsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "cut-offs" );

    /**
     * Create the instance of OdfCutOffsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCutOffsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:cut-offs}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink table:movement-cut-off}.
    *
    *@param position Integer   
    *@return   return  the element {@odfLink table:movement-cut-off}
    */
    public OdfMovementCutOffElement createMovementCutOffElement(Integer   position)
    {
        OdfMovementCutOffElement  nMovementCutOff = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMovementCutOffElement.class);
        nMovementCutOff.setPosition( position);
        this.appendChild( nMovementCutOff);
        return  nMovementCutOff;      
    }
    
    /**
    * Create child element {@odfLink table:movement-cut-off}.
    *
    *@param startPosition Integer   
    *@param endPosition Integer   
    *@return   return  the element {@odfLink table:movement-cut-off}
    */
    public OdfMovementCutOffElement createMovementCutOffElement(Integer   startPosition, Integer   endPosition)
    {
        OdfMovementCutOffElement  nMovementCutOff = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMovementCutOffElement.class);
        nMovementCutOff.setStartPosition( startPosition);
        nMovementCutOff.setEndPosition( endPosition);
        this.appendChild( nMovementCutOff);
        return  nMovementCutOff;      
    }
    
    /**
    * Create child element {@odfLink table:insertion-cut-off}.
    *
    *@param id String   
    *@param position Integer   
    *@return   return  the element {@odfLink table:insertion-cut-off}
    */
    public OdfInsertionCutOffElement createInsertionCutOffElement(String   id, Integer   position)
    {
        OdfInsertionCutOffElement  nInsertionCutOff = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfInsertionCutOffElement.class);
        nInsertionCutOff.setId( id);
        nInsertionCutOff.setPosition( position);
        this.appendChild( nInsertionCutOff);
        return  nInsertionCutOff;      
    }
    
}
