/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;

import java.net.URI;
import org.odftoolkit.odfdom.dom.element.office.OdfAnnotationElement;
import org.odftoolkit.odfdom.dom.element.text.OdfHeadingElement;
import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListElement;
import org.odftoolkit.odfdom.dom.element.text.OdfNumberedParagraphElement;
import org.odftoolkit.odfdom.dom.element.text.OdfSectionElement;
import org.odftoolkit.odfdom.dom.type.text.OdfSectionDisplayType;
import org.odftoolkit.odfdom.dom.element.text.OdfSoftPageBreakElement;
import org.odftoolkit.odfdom.dom.element.text.OdfTableOfContentElement;
import org.odftoolkit.odfdom.dom.element.text.OdfIllustrationIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfTableIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfObjectIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfUserIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfAlphabeticalIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfBibliographyElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRectElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfLineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPathElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfGroupElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfControlElement;
import org.odftoolkit.odfdom.dom.element.dr3d.OdfSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCustomShapeElement;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:covered-table-cell}.
 *
 */
public abstract class OdfCoveredTableCellElement extends OdfTableCellElementBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "covered-table-cell" );

    /**
     * Create the instance of OdfCoveredTableCellElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCoveredTableCellElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.TableCell, OdfName.get( OdfNamespace.TABLE, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:covered-table-cell}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink table:cell-range-source}.
    *
    *@param name String   
    *@param lastColumnSpanned  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param lastRowSpanned  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink table:cell-range-source}
    */
    public OdfCellRangeSourceElement createCellRangeSourceElement(String   name, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   lastColumnSpanned, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   lastRowSpanned, org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfCellRangeSourceElement  nCellRangeSource = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCellRangeSourceElement.class);
        nCellRangeSource.setName( name);
        nCellRangeSource.setLastColumnSpanned( lastColumnSpanned);
        nCellRangeSource.setLastRowSpanned( lastRowSpanned);
        nCellRangeSource.setHref( href);
        this.appendChild( nCellRangeSource);
        return  nCellRangeSource;      
    }
    
    /**
    * Create child element {@odfLink office:annotation}.
    *
    *@return   return  the element {@odfLink office:annotation}
    */
    public OdfAnnotationElement createAnnotationElement()
    {
        OdfAnnotationElement  nAnnotation = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnnotationElement.class);
        this.appendChild( nAnnotation);
        return  nAnnotation;
    }                   
               
    /**
    * Create child element {@odfLink table:detective}.
    *
    *@return   return  the element {@odfLink table:detective}
    */
    public OdfDetectiveElement createDetectiveElement()
    {
        OdfDetectiveElement  nDetective = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDetectiveElement.class);
        this.appendChild( nDetective);
        return  nDetective;
    }                   
               
    /**
    * Create child element {@odfLink text:h}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:h}
    */
    public OdfHeadingElement createHeadingElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel)
    {
        OdfHeadingElement  nHeading = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeadingElement.class);
        nHeading.setOutlineLevel( outlineLevel);
        this.appendChild( nHeading);
        return  nHeading;      
    }
    
    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
    /**
    * Create child element {@odfLink text:list}.
    *
    *@return   return  the element {@odfLink text:list}
    */
    public OdfListElement createListElement()
    {
        OdfListElement  nList = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListElement.class);
        this.appendChild( nList);
        return  nList;
    }                   
               
    /**
    * Create child element {@odfLink text:numbered-paragraph}.
    *
    *@param listId String   
    *@return   return  the element {@odfLink text:numbered-paragraph}
    */
    public OdfNumberedParagraphElement createNumberedParagraphElement(String   listId)
    {
        OdfNumberedParagraphElement  nNumberedParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNumberedParagraphElement.class);
        nNumberedParagraph.setListId( listId);
        this.appendChild( nNumberedParagraph);
        return  nNumberedParagraph;      
    }
    
    /**
    * Create child element {@odfLink table:table}.
    *
    *@return   return  the element {@odfLink table:table}
    */
    public OdfTableElement createTableElement()
    {
        OdfTableElement  nTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableElement.class);
        this.appendChild( nTable);
        return  nTable;
    }                   
               
    /**
    * Create child element {@odfLink text:section}.
    *
    *@param name String   
    *@param display     the attribute's type is OdfSectionDisplayType, see {@attributeName  text:section-display} at specification
    *@return   return  the element {@odfLink text:section}
    */
    public OdfSectionElement createSectionElement(String   name, OdfSectionDisplayType   display)
    {
        OdfSectionElement  nSection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSectionElement.class);
        nSection.setName( name);
        nSection.setDisplay( display);
        this.appendChild( nSection);
        return  nSection;      
    }
    
    /**
    * Create child element {@odfLink text:section}.
    *
    *@param display   the attribute's type is OdfSectionDisplayType, see {@attributeName  text:section-display} at specification
    *@param condition String   
    *@param name String   
    *@return   return  the element {@odfLink text:section}
    */
    public OdfSectionElement createSectionElement(OdfSectionDisplayType   display, String   condition, String   name)
    {
        OdfSectionElement  nSection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSectionElement.class);
        nSection.setDisplay( display);
        nSection.setCondition( condition);
        nSection.setName( name);
        this.appendChild( nSection);
        return  nSection;      
    }
    
    /**
    * Create child element {@odfLink text:soft-page-break}.
    *
    *@return   return  the element {@odfLink text:soft-page-break}
    */
    public OdfSoftPageBreakElement createSoftPageBreakElement()
    {
        OdfSoftPageBreakElement  nSoftPageBreak = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoftPageBreakElement.class);
        this.appendChild( nSoftPageBreak);
        return  nSoftPageBreak;
    }                   
               
    /**
    * Create child element {@odfLink text:table-of-content}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:table-of-content}
    */
    public OdfTableOfContentElement createTableOfContentElement(String   name)
    {
        OdfTableOfContentElement  nTableOfContent = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableOfContentElement.class);
        nTableOfContent.setName( name);
        this.appendChild( nTableOfContent);
        return  nTableOfContent;      
    }
    
    /**
    * Create child element {@odfLink text:illustration-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:illustration-index}
    */
    public OdfIllustrationIndexElement createIllustrationIndexElement(String   name)
    {
        OdfIllustrationIndexElement  nIllustrationIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIllustrationIndexElement.class);
        nIllustrationIndex.setName( name);
        this.appendChild( nIllustrationIndex);
        return  nIllustrationIndex;      
    }
    
    /**
    * Create child element {@odfLink text:table-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:table-index}
    */
    public OdfTableIndexElement createTableIndexElement(String   name)
    {
        OdfTableIndexElement  nTableIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableIndexElement.class);
        nTableIndex.setName( name);
        this.appendChild( nTableIndex);
        return  nTableIndex;      
    }
    
    /**
    * Create child element {@odfLink text:object-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:object-index}
    */
    public OdfObjectIndexElement createObjectIndexElement(String   name)
    {
        OdfObjectIndexElement  nObjectIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfObjectIndexElement.class);
        nObjectIndex.setName( name);
        this.appendChild( nObjectIndex);
        return  nObjectIndex;      
    }
    
    /**
    * Create child element {@odfLink text:user-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:user-index}
    */
    public OdfUserIndexElement createUserIndexElement(String   name)
    {
        OdfUserIndexElement  nUserIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserIndexElement.class);
        nUserIndex.setName( name);
        this.appendChild( nUserIndex);
        return  nUserIndex;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:alphabetical-index}
    */
    public OdfAlphabeticalIndexElement createAlphabeticalIndexElement(String   name)
    {
        OdfAlphabeticalIndexElement  nAlphabeticalIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexElement.class);
        nAlphabeticalIndex.setName( name);
        this.appendChild( nAlphabeticalIndex);
        return  nAlphabeticalIndex;      
    }
    
    /**
    * Create child element {@odfLink text:bibliography}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:bibliography}
    */
    public OdfBibliographyElement createBibliographyElement(String   name)
    {
        OdfBibliographyElement  nBibliography = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBibliographyElement.class);
        nBibliography.setName( name);
        this.appendChild( nBibliography);
        return  nBibliography;      
    }
    
    /**
    * Create child element {@odfLink draw:rect}.
    *
    *@return   return  the element {@odfLink draw:rect}
    */
    public OdfRectElement createRectElement()
    {
        OdfRectElement  nRect = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRectElement.class);
        this.appendChild( nRect);
        return  nRect;
    }                   
               
    /**
    * Create child element {@odfLink draw:line}.
    *
    *@param x1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param x2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink draw:line}
    */
    public OdfLineElement createLineElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        OdfLineElement  nLine = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLineElement.class);
        nLine.setX1( x1);
        nLine.setY1( y1);
        nLine.setX2( x2);
        nLine.setY2( y2);
        this.appendChild( nLine);
        return  nLine;      
    }
    
    /**
    * Create child element {@odfLink draw:polyline}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polyline}
    */
    public OdfPolylineElement createPolylineElement(String   points, Integer   viewBox)
    {
        OdfPolylineElement  nPolyline = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolylineElement.class);
        nPolyline.setPoints( points);
        nPolyline.setViewBox( viewBox);
        this.appendChild( nPolyline);
        return  nPolyline;      
    }
    
    /**
    * Create child element {@odfLink draw:polygon}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polygon}
    */
    public OdfPolygonElement createPolygonElement(String   points, Integer   viewBox)
    {
        OdfPolygonElement  nPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolygonElement.class);
        nPolygon.setPoints( points);
        nPolygon.setViewBox( viewBox);
        this.appendChild( nPolygon);
        return  nPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param concave   the attribute's type is Boolean
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners, org.odftoolkit.odfdom.dom.type.OdfBoolean   concave)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setCorners( corners);
        nRegularPolygon.setConcave( concave);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param concave   the attribute's type is Boolean
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   concave, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setConcave( concave);
        nRegularPolygon.setCorners( corners);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:path}.
    *
    *@param d String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:path}
    */
    public OdfPathElement createPathElement(String   d, Integer   viewBox)
    {
        OdfPathElement  nPath = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPathElement.class);
        nPath.setD( d);
        nPath.setViewBox( viewBox);
        this.appendChild( nPath);
        return  nPath;      
    }
    
    /**
    * Create child element {@odfLink draw:circle}.
    *
    *@return   return  the element {@odfLink draw:circle}
    */
    public OdfCircleElement createCircleElement()
    {
        OdfCircleElement  nCircle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCircleElement.class);
        this.appendChild( nCircle);
        return  nCircle;
    }                   
               
    /**
    * Create child element {@odfLink draw:ellipse}.
    *
    *@return   return  the element {@odfLink draw:ellipse}
    */
    public OdfEllipseElement createEllipseElement()
    {
        OdfEllipseElement  nEllipse = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEllipseElement.class);
        this.appendChild( nEllipse);
        return  nEllipse;
    }                   
               
    /**
    * Create child element {@odfLink draw:g}.
    *
    *@return   return  the element {@odfLink draw:g}
    */
    public OdfGroupElement createGroupElement()
    {
        OdfGroupElement  nGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGroupElement.class);
        this.appendChild( nGroup);
        return  nGroup;
    }                   
               
    /**
    * Create child element {@odfLink draw:page-thumbnail}.
    *
    *@return   return  the element {@odfLink draw:page-thumbnail}
    */
    public OdfPageThumbnailElement createPageThumbnailElement()
    {
        OdfPageThumbnailElement  nPageThumbnail = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageThumbnailElement.class);
        this.appendChild( nPageThumbnail);
        return  nPageThumbnail;
    }                   
               
    /**
    * Create child element {@odfLink draw:frame}.
    *
    *@return   return  the element {@odfLink draw:frame}
    */
    public OdfFrameElement createFrameElement()
    {
        OdfFrameElement  nFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFrameElement.class);
        this.appendChild( nFrame);
        return  nFrame;
    }                   
               
    /**
    * Create child element {@odfLink draw:measure}.
    *
    *@param x1  the attribute's type is String
    *@param y1  the attribute's type is String
    *@param x2  the attribute's type is String
    *@param y2  the attribute's type is String
    *@return   return  the element {@odfLink draw:measure}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement createdrawMeasureElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement  nMeasure = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement.class);
        nMeasure.setX1( x1);
        nMeasure.setY1( y1);
        nMeasure.setX2( x2);
        nMeasure.setY2( y2);
        this.appendChild( nMeasure);
        return  nMeasure;      
    }
    
    /**
    * Create child element {@odfLink draw:caption}.
    *
    *@return   return  the element {@odfLink draw:caption}
    */
    public OdfCaptionElement createCaptionElement()
    {
        OdfCaptionElement  nCaption = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCaptionElement.class);
        this.appendChild( nCaption);
        return  nCaption;
    }                   
               
    /**
    * Create child element {@odfLink draw:connector}.
    *
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:connector}
    */
    public OdfConnectorElement createConnectorElement(Integer   viewBox)
    {
        OdfConnectorElement  nConnector = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectorElement.class);
        nConnector.setViewBox( viewBox);
        this.appendChild( nConnector);
        return  nConnector;      
    }
    
    /**
    * Create child element {@odfLink draw:control}.
    *
    *@param control  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink draw:control}
    */
    public OdfControlElement createControlElement(org.odftoolkit.odfdom.dom.type.OdfId   control)
    {
        OdfControlElement  nControl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfControlElement.class);
        nControl.setControl( control);
        this.appendChild( nControl);
        return  nControl;      
    }
    
    /**
    * Create child element {@odfLink dr3d:scene}.
    *
    *@return   return  the element {@odfLink dr3d:scene}
    */
    public OdfSceneElement createSceneElement()
    {
        OdfSceneElement  nScene = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSceneElement.class);
        this.appendChild( nScene);
        return  nScene;
    }                   
               
    /**
    * Create child element {@odfLink draw:custom-shape}.
    *
    *@return   return  the element {@odfLink draw:custom-shape}
    */
    public OdfCustomShapeElement createCustomShapeElement()
    {
        OdfCustomShapeElement  nCustomShape = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCustomShapeElement.class);
        this.appendChild( nCustomShape);
        return  nCustomShape;
    }                   
               
    /**
    * Create child element {@odfLink draw:a}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink draw:a}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement createdrawHyperlinkElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement  nHyperlink = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement.class);
        nHyperlink.setHref( href);
        this.appendChild( nHyperlink);
        return  nHyperlink;      
    }
    
}
