/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.table.OdfDisplayListType;

import org.odftoolkit.odfdom.dom.element.office.OdfEventListenersElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:content-validation}.
 *
 */
public abstract class OdfContentValidationElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "content-validation" );

    /**
     * Create the instance of OdfContentValidationElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfContentValidationElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:content-validation}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfContentValidationElement}
     *
     *@param name  The mandatory attribute {@attributeName  table:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:condition}.
     *
     *@return return the attribute which type is String
     */
    public String getCondition()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "condition" ) );
    }

    /**
     * Set value of attribute {@attributeName table:condition}.
     *
     *@param  condition    the attribute's type is String
     */ 
     public void setCondition( String condition )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "condition" ), condition );
    }

    /**
     * Get value of attribute {@attributeName table:base-cell-address}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getBaseCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "base-cell-address" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:base-cell-address}.
     *
     *@param  baseCellAddress    the attribute's type is OdfCellAddress
     */ 
     public void setBaseCellAddress( OdfCellAddress baseCellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "base-cell-address" ), baseCellAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:allow-empty-cell}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAllowEmptyCell()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "allow-empty-cell" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:allow-empty-cell}.
     *
     *@param  isAllowEmptyCell    the attribute's type is OdfBoolean
     */ 
     public void setAllowEmptyCell( OdfBoolean isAllowEmptyCell )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "allow-empty-cell" ), isAllowEmptyCell.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:display-list}.
     *
     *@return return the attribute which type is OdfDisplayListType
     */
    public OdfDisplayListType getDisplayList()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-list" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "unsorted";
        }

        return OdfDisplayListType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:display-list}.
     *
     *@param  displayList    the attribute's type is OdfDisplayListType
     */ 
     public void setDisplayList( OdfDisplayListType displayList )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "display-list" ), displayList.toString() );
    }

    /**
    * Create child element {@odfLink table:help-message}.
    *
    *@return   return  the element {@odfLink table:help-message}
    */
    public OdfHelpMessageElement createHelpMessageElement()
    {
        OdfHelpMessageElement  nHelpMessage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHelpMessageElement.class);
        this.appendChild( nHelpMessage);
        return  nHelpMessage;
    }                   
               
    /**
    * Create child element {@odfLink table:error-message}.
    *
    *@return   return  the element {@odfLink table:error-message}
    */
    public OdfErrorMessageElement createErrorMessageElement()
    {
        OdfErrorMessageElement  nErrorMessage = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfErrorMessageElement.class);
        this.appendChild( nErrorMessage);
        return  nErrorMessage;
    }                   
               
    /**
    * Create child element {@odfLink table:error-macro}.
    *
    *@return   return  the element {@odfLink table:error-macro}
    */
    public OdfErrorMacroElement createErrorMacroElement()
    {
        OdfErrorMacroElement  nErrorMacro = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfErrorMacroElement.class);
        this.appendChild( nErrorMacro);
        return  nErrorMacro;
    }                   
               
    /**
    * Create child element {@odfLink office:event-listeners}.
    *
    *@return   return  the element {@odfLink office:event-listeners}
    */
    public OdfEventListenersElement createEventListenersElement()
    {
        OdfEventListenersElement  nEventListeners = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEventListenersElement.class);
        this.appendChild( nEventListeners);
        return  nEventListeners;
    }                   
               
}
