/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellRangeAddressList;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;
import org.odftoolkit.odfdom.dom.type.table.OdfUseLabelsType;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:consolidation}.
 *
 */
public abstract class OdfConsolidationElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "consolidation" );

    /**
     * Create the instance of OdfConsolidationElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfConsolidationElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:consolidation}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfConsolidationElement}
     *
     *@param function  The mandatory attribute {@attributeName  table:function}" 
     *@param sourceCellRangeAddresses  The mandatory attribute {@attributeName  table:source-cell-range-addresses}" 
     *@param targetCellAddress  The mandatory attribute {@attributeName  table:target-cell-address}" 
     *
     */
    public void init(String function, OdfCellRangeAddressList sourceCellRangeAddresses, OdfCellAddress targetCellAddress)
    {
        setFunction( function );
        setSourceCellRangeAddresses( sourceCellRangeAddresses );
        setTargetCellAddress( targetCellAddress );
    }

    /**
     * Get value of attribute {@attributeName table:function}.
     *
     *@return return the attribute which type is String
     */
    public String getFunction()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "function" ) );
    }

    /**
     * Set value of attribute {@attributeName table:function}.
     *
     *@param  function    the attribute's type is String
     */ 
     public void setFunction( String function )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "function" ), function );
    }

    /**
     * Get value of attribute {@attributeName table:source-cell-range-addresses}.
     *
     *@return return the attribute which type is OdfCellRangeAddressList
     */
    public OdfCellRangeAddressList getSourceCellRangeAddresses()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-cell-range-addresses" ) );
        return OdfCellRangeAddressList.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:source-cell-range-addresses}.
     *
     *@param  sourceCellRangeAddresses    the attribute's type is OdfCellRangeAddressList
     */ 
     public void setSourceCellRangeAddresses( OdfCellRangeAddressList sourceCellRangeAddresses )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "source-cell-range-addresses" ), sourceCellRangeAddresses.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:target-cell-address}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getTargetCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-cell-address" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:target-cell-address}.
     *
     *@param  targetCellAddress    the attribute's type is OdfCellAddress
     */ 
     public void setTargetCellAddress( OdfCellAddress targetCellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "target-cell-address" ), targetCellAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-labels}.
     *
     *@return return the attribute which type is OdfUseLabelsType
     */
    public OdfUseLabelsType getUseLabels()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-labels" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "none";
        }

        return OdfUseLabelsType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-labels}.
     *
     *@param  useLabels    the attribute's type is OdfUseLabelsType
     */ 
     public void setUseLabels( OdfUseLabelsType useLabels )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-labels" ), useLabels.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:link-to-source-data}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getLinkToSourceData()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "link-to-source-data" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:link-to-source-data}.
     *
     *@param  isLinkToSourceData    the attribute's type is OdfBoolean
     */ 
     public void setLinkToSourceData( OdfBoolean isLinkToSourceData )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "link-to-source-data" ), isLinkToSourceData.toString() );
    }

}
