/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import javax.xml.datatype.XMLGregorianCalendar;
import org.odftoolkit.odfdom.dom.type.OdfDate;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;

import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:change-track-table-cell}.
 *
 */
public abstract class OdfChangeTrackTableCellElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "change-track-table-cell" );

    /**
     * Create the instance of OdfChangeTrackTableCellElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfChangeTrackTableCellElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:change-track-table-cell}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:cell-address}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-address" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:cell-address}.
     *
     *@param  cellAddress    the attribute's type is OdfCellAddress
     */ 
     public void setCellAddress( OdfCellAddress cellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "cell-address" ), cellAddress.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:matrix-covered}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getMatrixCovered()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "matrix-covered" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:matrix-covered}.
     *
     *@param  isMatrixCovered    the attribute's type is OdfBoolean
     */ 
     public void setMatrixCovered( OdfBoolean isMatrixCovered )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "matrix-covered" ), isMatrixCovered.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:formula}.
     *
     *@return return the attribute which type is String
     */
    public String getFormula()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "formula" ) );
    }

    /**
     * Set value of attribute {@attributeName table:formula}.
     *
     *@param  formula    the attribute's type is String
     */ 
     public void setFormula( String formula )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "formula" ), formula );
    }

    /**
     * Get value of attribute {@attributeName table:number-matrix-columns-spanned}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getNumberMatrixColumnsSpanned()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-matrix-columns-spanned" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:number-matrix-columns-spanned}.
     *
     *@param  numberMatrixColumnsSpanned    the attribute's type is OdfPositiveInteger
     */ 
     public void setNumberMatrixColumnsSpanned( OdfPositiveInteger numberMatrixColumnsSpanned )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-matrix-columns-spanned" ), numberMatrixColumnsSpanned.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:number-matrix-rows-spanned}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getNumberMatrixRowsSpanned()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-matrix-rows-spanned" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:number-matrix-rows-spanned}.
     *
     *@param  numberMatrixRowsSpanned    the attribute's type is OdfPositiveInteger
     */ 
     public void setNumberMatrixRowsSpanned( OdfPositiveInteger numberMatrixRowsSpanned )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "number-matrix-rows-spanned" ), numberMatrixRowsSpanned.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:value-type}.
     *
     *@return return the attribute which type is OdfValueType
     */
    public OdfValueType getValueType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ) );
        return OdfValueType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value-type}.
     *
     *@param  valueType    the attribute's type is OdfValueType
     */ 
     public void setValueType( OdfValueType valueType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value-type" ), valueType.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:value}.
     *
     *@return return the attribute which type is Double
     */
    public Double getValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:value}.
     *
     *@param  value    the attribute's type is Double
     */ 
     public void setValue( Double value )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "value" ), value.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:currency}.
     *
     *@return return the attribute which type is String
     */
    public String getCurrency()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ) );
    }

    /**
     * Set value of attribute {@attributeName office:currency}.
     *
     *@param  currency    the attribute's type is String
     */ 
     public void setCurrency( String currency )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "currency" ), currency );
    }

    /**
     * Get value of attribute {@attributeName office:date-value}.
     *
     *@return return the attribute which type is OdfDate
     */
    public OdfDate getDateValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ) );
        return OdfDate.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:date-value}.
     *
     *@param  dateValue    the attribute's type is OdfDate
     */ 
     public void setDateValue( OdfDate dateValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "date-value" ), dateValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:time-value}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getTimeValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:time-value}.
     *
     *@param  timeValue    the attribute's type is OdfDuration
     */ 
     public void setTimeValue( OdfDuration timeValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "time-value" ), timeValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:boolean-value}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getBooleanValue()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName office:boolean-value}.
     *
     *@param  isBooleanValue    the attribute's type is OdfBoolean
     */ 
     public void setBooleanValue( OdfBoolean isBooleanValue )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "boolean-value" ), isBooleanValue.toString() );
    }

    /**
     * Get value of attribute {@attributeName office:string-value}.
     *
     *@return return the attribute which type is String
     */
    public String getStringValue()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ) );
    }

    /**
     * Set value of attribute {@attributeName office:string-value}.
     *
     *@param  stringValue    the attribute's type is String
     */ 
     public void setStringValue( String stringValue )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.OFFICE, "string-value" ), stringValue );
    }

    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
}
