/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.type.OdfDuration;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:cell-range-source}.
 *
 */
public abstract class OdfCellRangeSourceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "cell-range-source" );

    /**
     * Create the instance of OdfCellRangeSourceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCellRangeSourceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:cell-range-source}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfCellRangeSourceElement}
     *
     *@param name  The mandatory attribute {@attributeName  table:name}" 
     *@param lastColumnSpanned  The mandatory attribute {@attributeName  table:last-column-spanned}" 
     *@param lastRowSpanned  The mandatory attribute {@attributeName  table:last-row-spanned}" 
     *
     */
    public void init(String name, OdfPositiveInteger lastColumnSpanned, OdfPositiveInteger lastRowSpanned)
    {
        setName( name );
        setLastColumnSpanned( lastColumnSpanned );
        setLastRowSpanned( lastRowSpanned );
    }

    /**
     * Get value of attribute {@attributeName table:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName table:last-column-spanned}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getLastColumnSpanned()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-column-spanned" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:last-column-spanned}.
     *
     *@param  lastColumnSpanned    the attribute's type is OdfPositiveInteger
     */ 
     public void setLastColumnSpanned( OdfPositiveInteger lastColumnSpanned )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-column-spanned" ), lastColumnSpanned.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:last-row-spanned}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getLastRowSpanned()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-row-spanned" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:last-row-spanned}.
     *
     *@param  lastRowSpanned    the attribute's type is OdfPositiveInteger
     */ 
     public void setLastRowSpanned( OdfPositiveInteger lastRowSpanned )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "last-row-spanned" ), lastRowSpanned.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onRequest" );
    }

    /**
     * Get value of attribute {@attributeName table:filter-name}.
     *
     *@return return the attribute which type is String
     */
    public String getFilterName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "filter-name" ) );
    }

    /**
     * Set value of attribute {@attributeName table:filter-name}.
     *
     *@param  filterName    the attribute's type is String
     */ 
     public void setFilterName( String filterName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "filter-name" ), filterName );
    }

    /**
     * Get value of attribute {@attributeName table:filter-options}.
     *
     *@return return the attribute which type is String
     */
    public String getFilterOptions()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "filter-options" ) );
    }

    /**
     * Set value of attribute {@attributeName table:filter-options}.
     *
     *@param  filterOptions    the attribute's type is String
     */ 
     public void setFilterOptions( String filterOptions )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "filter-options" ), filterOptions );
    }

    /**
     * Get value of attribute {@attributeName table:refresh-delay}.
     *
     *@return return the attribute which type is OdfDuration
     */
    public OdfDuration getRefreshDelay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "refresh-delay" ) );
        return OdfDuration.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:refresh-delay}.
     *
     *@param  refreshDelay    the attribute's type is OdfDuration
     */ 
     public void setRefreshDelay( OdfDuration refreshDelay )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "refresh-delay" ), refreshDelay.toString() );
    }

}
