/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:cell-content-deletion}.
 *
 */
public abstract class OdfCellContentDeletionElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "cell-content-deletion" );

    /**
     * Create the instance of OdfCellContentDeletionElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCellContentDeletionElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:cell-content-deletion}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName table:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "id" ), id );
    }

    /**
    * Create child element {@odfLink table:cell-address}.
    *
    *@param column Integer   
    *@param row Integer   
    *@param table Integer   
    *@return   return  the element {@odfLink table:cell-address}
    */
    public OdfCellAddressElement createCellAddressElement(Integer   column, Integer   row, Integer   table)
    {
        OdfCellAddressElement  nCellAddress = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCellAddressElement.class);
        nCellAddress.setColumn( column);
        nCellAddress.setRow( row);
        nCellAddress.setTable( table);
        this.appendChild( nCellAddress);
        return  nCellAddress;      
    }
    
    /**
    * Create child element {@odfLink table:change-track-table-cell}.
    *
    *@return   return  the element {@odfLink table:change-track-table-cell}
    */
    public OdfChangeTrackTableCellElement createChangeTrackTableCellElement()
    {
        OdfChangeTrackTableCellElement  nChangeTrackTableCell = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChangeTrackTableCellElement.class);
        this.appendChild( nChangeTrackTableCell);
        return  nChangeTrackTableCell;
    }                   
               
}
