/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.table.OdfAcceptanceStateType;

import org.odftoolkit.odfdom.dom.element.office.OdfChangeInfoElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:cell-content-change}.
 *
 */
public abstract class OdfCellContentChangeElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "cell-content-change" );

    /**
     * Create the instance of OdfCellContentChangeElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCellContentChangeElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:cell-content-change}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfCellContentChangeElement}
     *
     *@param id  The mandatory attribute {@attributeName  table:id}" 
     *
     */
    public void init(String id)
    {
        setId( id );
    }

    /**
     * Get value of attribute {@attributeName table:id}.
     *
     *@return return the attribute which type is String
     */
    public String getId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "id" ) );
    }

    /**
     * Set value of attribute {@attributeName table:id}.
     *
     *@param  id    the attribute's type is String
     */ 
     public void setId( String id )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "id" ), id );
    }

    /**
     * Get value of attribute {@attributeName table:acceptance-state}.
     *
     *@return return the attribute which type is OdfAcceptanceStateType
     */
    public OdfAcceptanceStateType getAcceptanceState()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "acceptance-state" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "pending";
        }

        return OdfAcceptanceStateType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:acceptance-state}.
     *
     *@param  acceptanceState    the attribute's type is OdfAcceptanceStateType
     */ 
     public void setAcceptanceState( OdfAcceptanceStateType acceptanceState )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "acceptance-state" ), acceptanceState.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:rejecting-change-id}.
     *
     *@return return the attribute which type is String
     */
    public String getRejectingChangeId()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "rejecting-change-id" ) );
    }

    /**
     * Set value of attribute {@attributeName table:rejecting-change-id}.
     *
     *@param  rejectingChangeId    the attribute's type is String
     */ 
     public void setRejectingChangeId( String rejectingChangeId )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "rejecting-change-id" ), rejectingChangeId );
    }

    /**
    * Create child element {@odfLink table:cell-address}.
    *
    *@param column Integer   
    *@param row Integer   
    *@param table Integer   
    *@return   return  the element {@odfLink table:cell-address}
    */
    public OdfCellAddressElement createCellAddressElement(Integer   column, Integer   row, Integer   table)
    {
        OdfCellAddressElement  nCellAddress = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCellAddressElement.class);
        nCellAddress.setColumn( column);
        nCellAddress.setRow( row);
        nCellAddress.setTable( table);
        this.appendChild( nCellAddress);
        return  nCellAddress;      
    }
    
    /**
    * Create child element {@odfLink office:change-info}.
    *
    *@return   return  the element {@odfLink office:change-info}
    */
    public OdfChangeInfoElement createChangeInfoElement()
    {
        OdfChangeInfoElement  nChangeInfo = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChangeInfoElement.class);
        this.appendChild( nChangeInfo);
        return  nChangeInfo;
    }                   
               
    /**
    * Create child element {@odfLink table:dependencies}.
    *
    *@return   return  the element {@odfLink table:dependencies}
    */
    public OdfDependenciesElement createDependenciesElement()
    {
        OdfDependenciesElement  nDependencies = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDependenciesElement.class);
        this.appendChild( nDependencies);
        return  nDependencies;
    }                   
               
    /**
    * Create child element {@odfLink table:deletions}.
    *
    *@return   return  the element {@odfLink table:deletions}
    */
    public OdfDeletionsElement createDeletionsElement()
    {
        OdfDeletionsElement  nDeletions = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDeletionsElement.class);
        this.appendChild( nDeletions);
        return  nDeletions;
    }                   
               
    /**
    * Create child element {@odfLink table:previous}.
    *
    *@return   return  the element {@odfLink table:previous}
    */
    public OdfPreviousElement createPreviousElement()
    {
        OdfPreviousElement  nPrevious = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPreviousElement.class);
        this.appendChild( nPrevious);
        return  nPrevious;
    }                   
               
}
