/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:cell-address}.
 *
 */
public abstract class OdfCellAddressElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "cell-address" );

    /**
     * Create the instance of OdfCellAddressElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCellAddressElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:cell-address}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfCellAddressElement}
     *
     *@param column  The mandatory attribute {@attributeName  table:column}" 
     *@param row  The mandatory attribute {@attributeName  table:row}" 
     *@param table  The mandatory attribute {@attributeName  table:table}" 
     *
     */
    public void init(Integer column, Integer row, Integer table)
    {
        setColumn( column );
        setRow( row );
        setTable( table );
    }

    /**
     * Get value of attribute {@attributeName table:column}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getColumn()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "column" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:column}.
     *
     *@param  column    the attribute's type is Integer
     */ 
     public void setColumn( Integer column )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "column" ), column.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:row}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getRow()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "row" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:row}.
     *
     *@param  row    the attribute's type is Integer
     */ 
     public void setRow( Integer row )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "row" ), row.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:table}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getTable()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:table}.
     *
     *@param  table    the attribute's type is Integer
     */ 
     public void setTable( Integer table )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "table" ), table.toString() );
    }

}
