/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.table;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink table:calculation-settings}.
 *
 */
public abstract class OdfCalculationSettingsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.TABLE, "calculation-settings" );

    /**
     * Create the instance of OdfCalculationSettingsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfCalculationSettingsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink table:calculation-settings}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName table:case-sensitive}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getCaseSensitive()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:case-sensitive}.
     *
     *@param  isCaseSensitive    the attribute's type is OdfBoolean
     */ 
     public void setCaseSensitive( OdfBoolean isCaseSensitive )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "case-sensitive" ), isCaseSensitive.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:precision-as-shown}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getPrecisionAsShown()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "precision-as-shown" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:precision-as-shown}.
     *
     *@param  isPrecisionAsShown    the attribute's type is OdfBoolean
     */ 
     public void setPrecisionAsShown( OdfBoolean isPrecisionAsShown )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "precision-as-shown" ), isPrecisionAsShown.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:search-criteria-must-apply-to-whole-cell}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getSearchCriteriaMustApplyToWholeCell()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "search-criteria-must-apply-to-whole-cell" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:search-criteria-must-apply-to-whole-cell}.
     *
     *@param  isSearchCriteriaMustApplyToWholeCell    the attribute's type is OdfBoolean
     */ 
     public void setSearchCriteriaMustApplyToWholeCell( OdfBoolean isSearchCriteriaMustApplyToWholeCell )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "search-criteria-must-apply-to-whole-cell" ), isSearchCriteriaMustApplyToWholeCell.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:automatic-find-labels}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAutomaticFindLabels()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "automatic-find-labels" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:automatic-find-labels}.
     *
     *@param  isAutomaticFindLabels    the attribute's type is OdfBoolean
     */ 
     public void setAutomaticFindLabels( OdfBoolean isAutomaticFindLabels )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "automatic-find-labels" ), isAutomaticFindLabels.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-regular-expressions}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseRegularExpressions()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-regular-expressions" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-regular-expressions}.
     *
     *@param  isUseRegularExpressions    the attribute's type is OdfBoolean
     */ 
     public void setUseRegularExpressions( OdfBoolean isUseRegularExpressions )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-regular-expressions" ), isUseRegularExpressions.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:use-wildcards}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getUseWildcards()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-wildcards" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:use-wildcards}.
     *
     *@param  isUseWildcards    the attribute's type is OdfBoolean
     */ 
     public void setUseWildcards( OdfBoolean isUseWildcards )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "use-wildcards" ), isUseWildcards.toString() );
    }

    /**
     * Get value of attribute {@attributeName table:null-year}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getNullYear()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TABLE, "null-year" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "1930";
        }

        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName table:null-year}.
     *
     *@param  nullYear    the attribute's type is OdfPositiveInteger
     */ 
     public void setNullYear( OdfPositiveInteger nullYear )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TABLE, "null-year" ), nullYear.toString() );
    }

    /**
    * Create child element {@odfLink table:null-date}.
    *
    *@return   return  the element {@odfLink table:null-date}
    */
    public OdfNullDateElement createNullDateElement()
    {
        OdfNullDateElement  nNullDate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNullDateElement.class);
        this.appendChild( nNullDate);
        return  nNullDate;
    }                   
               
    /**
    * Create child element {@odfLink table:iteration}.
    *
    *@return   return  the element {@odfLink table:iteration}
    */
    public OdfIterationElement createIterationElement()
    {
        OdfIterationElement  nIteration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIterationElement.class);
        this.appendChild( nIteration);
        return  nIteration;
    }                   
               
}
