/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.svg;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink svg:stop}.
 *
 */
public abstract class OdfStopElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.SVG, "stop" );

    /**
     * Create the instance of OdfStopElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfStopElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink svg:stop}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfStopElement}
     *
     *@param offset  The mandatory attribute {@attributeName  svg:offset}" 
     *
     */
    public void init(Double offset)
    {
        setOffset( offset );
    }

    /**
     * Get value of attribute {@attributeName svg:offset}.
     *
     *@return return the attribute which type is Double
     */
    public Double getOffset()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "offset" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:offset}.
     *
     *@param  offset    the attribute's type is Double
     */ 
     public void setOffset( Double offset )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "offset" ), offset.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:stop-color}.
     *
     *@return return the attribute which type is String
     */
    public String getStopColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "stop-color" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:stop-color}.
     *
     *@param  stopColor    the attribute's type is String
     */ 
     public void setStopColor( String stopColor )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "stop-color" ), stopColor );
    }

    /**
     * Get value of attribute {@attributeName svg:stop-opacity}.
     *
     *@return return the attribute which type is Double
     */
    public Double getStopOpacity()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "stop-opacity" ) );
        return Double.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:stop-opacity}.
     *
     *@param  stopOpacity    the attribute's type is Double
     */ 
     public void setStopOpacity( Double stopOpacity )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "stop-opacity" ), stopOpacity.toString() );
    }

}
