/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.svg;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.svg.OdfSpreadMethodType;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink svg:linearGradient}.
 *
 */
public abstract class OdfLinearGradientElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.SVG, "linearGradient" );

    /**
     * Create the instance of OdfLinearGradientElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfLinearGradientElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink svg:linearGradient}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfLinearGradientElement}
     *
     *@param name  The mandatory attribute {@attributeName  draw:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName svg:gradientUnits}.
     *
     *@return return the attribute which type is String
     */
    public String getGradientUnits()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "gradientUnits" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "objectBoundingBox";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:gradientUnits}.
     *
     *@param  gradientUnits    the attribute's type is String
     */ 
     public void setGradientUnits( String gradientUnits )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "gradientUnits" ), gradientUnits );
    }

    /**
     * Get value of attribute {@attributeName svg:gradientTransform}.
     *
     *@return return the attribute which type is String
     */
    public String getGradientTransform()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "gradientTransform" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:gradientTransform}.
     *
     *@param  gradientTransform    the attribute's type is String
     */ 
     public void setGradientTransform( String gradientTransform )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "gradientTransform" ), gradientTransform );
    }

    /**
     * Get value of attribute {@attributeName svg:spreadMethod}.
     *
     *@return return the attribute which type is OdfSpreadMethodType
     */
    public OdfSpreadMethodType getSpreadMethod()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "spreadMethod" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "pad";
        }

        return OdfSpreadMethodType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:spreadMethod}.
     *
     *@param  spreadMethod    the attribute's type is OdfSpreadMethodType
     */ 
     public void setSpreadMethod( OdfSpreadMethodType spreadMethod )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "spreadMethod" ), spreadMethod.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName draw:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName svg:x1}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX1()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x1" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0%";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x1}.
     *
     *@param  x1    the attribute's type is OdfLength
     */ 
     public void setX1( OdfLength x1 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x1" ), x1.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y1}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY1()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y1" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0%";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y1}.
     *
     *@param  y1    the attribute's type is OdfLength
     */ 
     public void setY1( OdfLength y1 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y1" ), y1.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x2}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getX2()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x2" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "100%";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x2}.
     *
     *@param  x2    the attribute's type is OdfLength
     */ 
     public void setX2( OdfLength x2 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x2" ), x2.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:y2}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getY2()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "y2" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "100%";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:y2}.
     *
     *@param  y2    the attribute's type is OdfLength
     */ 
     public void setY2( OdfLength y2 )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "y2" ), y2.toString() );
    }

    /**
    * Create child element {@odfLink svg:stop}.
    *
    *@param offset Double   
    *@return   return  the element {@odfLink svg:stop}
    */
    public OdfStopElement createStopElement(Double   offset)
    {
        OdfStopElement  nStop = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStopElement.class);
        nStop.setOffset( offset);
        this.appendChild( nStop);
        return  nStop;      
    }
    
}
