/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.svg;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import java.net.URI;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink svg:font-face-src}.
 *
 */
public abstract class OdfFontFaceSrcElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.SVG, "font-face-src" );

    /**
     * Create the instance of OdfFontFaceSrcElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFontFaceSrcElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink svg:font-face-src}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink svg:font-face-uri}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink svg:font-face-uri}
    */
    public OdfFontFaceUriElement createFontFaceUriElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfFontFaceUriElement  nFontFaceUri = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFontFaceUriElement.class);
        nFontFaceUri.setHref( href);
        this.appendChild( nFontFaceUri);
        return  nFontFaceUri;      
    }
    
    /**
    * Create child element {@odfLink svg:font-face-name}.
    *
    *@return   return  the element {@odfLink svg:font-face-name}
    */
    public OdfFontFaceNameElement createFontFaceNameElement()
    {
        OdfFontFaceNameElement  nFontFaceName = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFontFaceNameElement.class);
        this.appendChild( nFontFaceName);
        return  nFontFaceName;
    }                   
               
}
