/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:text-properties}.
 *
 */
public abstract class OdfTextPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "text-properties" );

    /**
     * Create the instance of OdfTextPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTextPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:text-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty FontVariant = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "font-variant"));
    public final static OdfStyleProperty TextTransform = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "text-transform"));
    public final static OdfStyleProperty Color = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "color"));
    public final static OdfStyleProperty UseWindowFontColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "use-window-font-color"));
    public final static OdfStyleProperty TextOutline = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-outline"));
    public final static OdfStyleProperty TextLineThroughType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-line-through-type"));
    public final static OdfStyleProperty TextLineThroughStyle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-line-through-style"));
    public final static OdfStyleProperty TextLineThroughWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-line-through-width"));
    public final static OdfStyleProperty TextLineThroughColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-line-through-color"));
    public final static OdfStyleProperty TextLineThroughText = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-line-through-text"));
    public final static OdfStyleProperty TextLineThroughTextStyle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-line-through-text-style"));
    public final static OdfStyleProperty TextPosition = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-position"));
    public final static OdfStyleProperty FontName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-name"));
    public final static OdfStyleProperty FontNameAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-name-asian"));
    public final static OdfStyleProperty FontNameComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-name-complex"));
    public final static OdfStyleProperty FontFamily = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "font-family"));
    public final static OdfStyleProperty FontFamilyAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-family-asian"));
    public final static OdfStyleProperty FontFamilyComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-family-complex"));
    public final static OdfStyleProperty FontFamilyGeneric = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-family-generic"));
    public final static OdfStyleProperty FontFamilyGenericAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-family-generic-asian"));
    public final static OdfStyleProperty FontFamilyGenericComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-family-generic-complex"));
    public final static OdfStyleProperty FontStyleName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-style-name"));
    public final static OdfStyleProperty FontStyleNameAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-style-name-asian"));
    public final static OdfStyleProperty FontStyleNameComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-style-name-complex"));
    public final static OdfStyleProperty FontPitch = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-pitch"));
    public final static OdfStyleProperty FontPitchAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-pitch-asian"));
    public final static OdfStyleProperty FontPitchComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-pitch-complex"));
    public final static OdfStyleProperty FontCharset = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-charset"));
    public final static OdfStyleProperty FontCharsetAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-charset-asian"));
    public final static OdfStyleProperty FontCharsetComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-charset-complex"));
    public final static OdfStyleProperty FontSize = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "font-size"));
    public final static OdfStyleProperty FontSizeAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-size-asian"));
    public final static OdfStyleProperty FontSizeComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-size-complex"));
    public final static OdfStyleProperty FontSizeRel = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-size-rel"));
    public final static OdfStyleProperty FontSizeRelAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-size-rel-asian"));
    public final static OdfStyleProperty FontSizeRelComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-size-rel-complex"));
    public final static OdfStyleProperty ScriptType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "script-type"));
    public final static OdfStyleProperty LetterSpacing = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "letter-spacing"));
    public final static OdfStyleProperty Language = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "language"));
    public final static OdfStyleProperty LanguageAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "language-asian"));
    public final static OdfStyleProperty LanguageComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "language-complex"));
    public final static OdfStyleProperty Country = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "country"));
    public final static OdfStyleProperty CountryAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "country-asian"));
    public final static OdfStyleProperty CountryComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "country-complex"));
    public final static OdfStyleProperty Script = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "script"));
    public final static OdfStyleProperty ScriptAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "script-asian"));
    public final static OdfStyleProperty ScriptComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "script-complex"));
    public final static OdfStyleProperty RfcLanguageTag = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "rfc-language-tag"));
    public final static OdfStyleProperty RfcLanguageTagAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "rfc-language-tag-asian"));
    public final static OdfStyleProperty RfcLanguageTagComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "rfc-language-tag-complex"));
    public final static OdfStyleProperty FontStyle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "font-style"));
    public final static OdfStyleProperty FontStyleAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-style-asian"));
    public final static OdfStyleProperty FontStyleComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-style-complex"));
    public final static OdfStyleProperty FontRelief = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-relief"));
    public final static OdfStyleProperty TextShadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "text-shadow"));
    public final static OdfStyleProperty TextUnderlineType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-underline-type"));
    public final static OdfStyleProperty TextUnderlineStyle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-underline-style"));
    public final static OdfStyleProperty TextUnderlineWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-underline-width"));
    public final static OdfStyleProperty TextUnderlineColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-underline-color"));
    public final static OdfStyleProperty TextOverlineType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-overline-type"));
    public final static OdfStyleProperty TextOverlineStyle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-overline-style"));
    public final static OdfStyleProperty TextOverlineWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-overline-width"));
    public final static OdfStyleProperty TextOverlineColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-overline-color"));
    public final static OdfStyleProperty TextOverlineMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-overline-mode"));
    public final static OdfStyleProperty FontWeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "font-weight"));
    public final static OdfStyleProperty FontWeightAsian = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-weight-asian"));
    public final static OdfStyleProperty FontWeightComplex = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "font-weight-complex"));
    public final static OdfStyleProperty TextUnderlineMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-underline-mode"));
    public final static OdfStyleProperty TextLineThroughMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-line-through-mode"));
    public final static OdfStyleProperty LetterKerning = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "letter-kerning"));
    public final static OdfStyleProperty TextBlinking = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-blinking"));
    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "background-color"));
    public final static OdfStyleProperty TextCombine = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-combine"));
    public final static OdfStyleProperty TextCombineStartChar = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-combine-start-char"));
    public final static OdfStyleProperty TextCombineEndChar = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-combine-end-char"));
    public final static OdfStyleProperty TextEmphasize = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-emphasize"));
    public final static OdfStyleProperty TextScale = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-scale"));
    public final static OdfStyleProperty TextRotationAngle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-rotation-angle"));
    public final static OdfStyleProperty TextRotationScale = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.STYLE, "text-rotation-scale"));
    public final static OdfStyleProperty Hyphenate = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "hyphenate"));
    public final static OdfStyleProperty HyphenationRemainCharCount = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "hyphenation-remain-char-count"));
    public final static OdfStyleProperty HyphenationPushCharCount = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.FO, "hyphenation-push-char-count"));
    public final static OdfStyleProperty Display = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.TEXT, "display"));
    public final static OdfStyleProperty Condition = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TextProperties, OdfName.get(OdfNamespace.TEXT, "condition"));

}
