/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

import org.odftoolkit.odfdom.dom.element.office.OdfBinaryDataElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:table-row-properties}.
 *
 */
public abstract class OdfTableRowPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "table-row-properties" );

    /**
     * Create the instance of OdfTableRowPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableRowPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:table-row-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty RowHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableRowProperties, OdfName.get(OdfNamespace.STYLE, "row-height"));
    public final static OdfStyleProperty MinRowHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableRowProperties, OdfName.get(OdfNamespace.STYLE, "min-row-height"));
    public final static OdfStyleProperty UseOptimalRowHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableRowProperties, OdfName.get(OdfNamespace.STYLE, "use-optimal-row-height"));
    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableRowProperties, OdfName.get(OdfNamespace.FO, "background-color"));
    public final static OdfStyleProperty BreakBefore = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableRowProperties, OdfName.get(OdfNamespace.FO, "break-before"));
    public final static OdfStyleProperty BreakAfter = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableRowProperties, OdfName.get(OdfNamespace.FO, "break-after"));
    public final static OdfStyleProperty KeepTogether = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableRowProperties, OdfName.get(OdfNamespace.FO, "keep-together"));

    /**
    * Create child element {@odfLink office:binary-data}.
    *
    *@return   return  the element {@odfLink office:binary-data}
    */
    public OdfBinaryDataElement createBinaryDataElement()
    {
        OdfBinaryDataElement  nBinaryData = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBinaryDataElement.class);
        this.appendChild( nBinaryData);
        return  nBinaryData;
    }                   
               
}
