/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

import org.odftoolkit.odfdom.dom.element.office.OdfBinaryDataElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:table-cell-properties}.
 *
 */
public abstract class OdfTableCellPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "table-cell-properties" );

    /**
     * Create the instance of OdfTableCellPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTableCellPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:table-cell-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty VerticalAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "vertical-align"));
    public final static OdfStyleProperty TextAlignSource = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "text-align-source"));
    public final static OdfStyleProperty Direction = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "direction"));
    public final static OdfStyleProperty GlyphOrientationVertical = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "glyph-orientation-vertical"));
    public final static OdfStyleProperty WritingMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "writing-mode"));
    public final static OdfStyleProperty Shadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "shadow"));
    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "background-color"));
    public final static OdfStyleProperty Border = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "border"));
    public final static OdfStyleProperty BorderTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "border-top"));
    public final static OdfStyleProperty BorderBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "border-bottom"));
    public final static OdfStyleProperty BorderLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "border-left"));
    public final static OdfStyleProperty BorderRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "border-right"));
    public final static OdfStyleProperty DiagonalTlBr = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "diagonal-tl-br"));
    public final static OdfStyleProperty DiagonalTlBrWidths = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "diagonal-tl-br-widths"));
    public final static OdfStyleProperty DiagonalBlTr = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "diagonal-bl-tr"));
    public final static OdfStyleProperty DiagonalBlTrWidths = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "diagonal-bl-tr-widths"));
    public final static OdfStyleProperty BorderLineWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width"));
    public final static OdfStyleProperty BorderLineWidthTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-top"));
    public final static OdfStyleProperty BorderLineWidthBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-bottom"));
    public final static OdfStyleProperty BorderLineWidthLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-left"));
    public final static OdfStyleProperty BorderLineWidthRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-right"));
    public final static OdfStyleProperty Padding = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "padding"));
    public final static OdfStyleProperty PaddingTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "padding-top"));
    public final static OdfStyleProperty PaddingBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "padding-bottom"));
    public final static OdfStyleProperty PaddingLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "padding-left"));
    public final static OdfStyleProperty PaddingRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "padding-right"));
    public final static OdfStyleProperty WrapOption = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.FO, "wrap-option"));
    public final static OdfStyleProperty RotationAngle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "rotation-angle"));
    public final static OdfStyleProperty RotationAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "rotation-align"));
    public final static OdfStyleProperty CellProtect = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "cell-protect"));
    public final static OdfStyleProperty PrintContent = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "print-content"));
    public final static OdfStyleProperty DecimalPlaces = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "decimal-places"));
    public final static OdfStyleProperty RepeatContent = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "repeat-content"));
    public final static OdfStyleProperty ShrinkToFit = 
        OdfStyleProperty.get(OdfStylePropertiesSet.TableCellProperties, OdfName.get(OdfNamespace.STYLE, "shrink-to-fit"));

    /**
    * Create child element {@odfLink office:binary-data}.
    *
    *@return   return  the element {@odfLink office:binary-data}
    */
    public OdfBinaryDataElement createBinaryDataElement()
    {
        OdfBinaryDataElement  nBinaryData = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBinaryDataElement.class);
        this.appendChild( nBinaryData);
        return  nBinaryData;
    }                   
               
}
