/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;

import org.odftoolkit.odfdom.dom.type.style.OdfTabStopType;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:tab-stops}.
 *
 */
public abstract class OdfTabStopsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "tab-stops" );

    /**
     * Create the instance of OdfTabStopsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTabStopsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:tab-stops}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
    * Create child element {@odfLink style:tab-stop}.
    *
    *@param type   the attribute's type is OdfTabStopType, see {@attributeName  style:tab-stop} at specification
    *@param position  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink style:tab-stop}
    */
    public OdfTabStopElement createTabStopElement(OdfTabStopType   type, org.odftoolkit.odfdom.dom.type.OdfLength   position)
    {
        OdfTabStopElement  nTabStop = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTabStopElement.class);
        nTabStop.setType( type);
        nTabStop.setPosition( position);
        this.appendChild( nTabStop);
        return  nTabStop;      
    }
    
}
