/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.style.OdfTabStopType;
import org.odftoolkit.odfdom.dom.type.style.OdfLeaderType;
import org.odftoolkit.odfdom.dom.type.style.OdfLeaderStyleType;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:tab-stop}.
 *
 */
public abstract class OdfTabStopElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "tab-stop" );

    /**
     * Create the instance of OdfTabStopElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfTabStopElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:tab-stop}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfTabStopElement}
     *
     *@param position  The mandatory attribute {@attributeName  style:position}" 
     *
     */
    public void init(OdfLength position)
    {
        setPosition( position );
    }

    /**
     * Get value of attribute {@attributeName style:position}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "position" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:position}.
     *
     *@param  position    the attribute's type is OdfLength
     */ 
     public void setPosition( OdfLength position )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "position" ), position.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:type}.
     *
     *@return return the attribute which type is OdfTabStopType
     */
    public OdfTabStopType getType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "type" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "left";
        }

        return OdfTabStopType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:type}.
     *
     *@param  type    the attribute's type is OdfTabStopType
     */ 
     public void setType( OdfTabStopType type )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "type" ), type.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:char}.
     *
     *@return return the attribute which type is String
     */
    public String getChar()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "char" ) );
    }

    /**
     * Set value of attribute {@attributeName style:char}.
     *
     *@param  styleChar    the attribute's type is String
     */ 
     public void setChar( String styleChar )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "char" ), styleChar );
    }

    /**
     * Get value of attribute {@attributeName style:leader-type}.
     *
     *@return return the attribute which type is OdfLeaderType
     */
    public OdfLeaderType getLeaderType()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-type" ) );
        return OdfLeaderType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:leader-type}.
     *
     *@param  leaderType    the attribute's type is OdfLeaderType
     */ 
     public void setLeaderType( OdfLeaderType leaderType )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-type" ), leaderType.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:leader-style}.
     *
     *@return return the attribute which type is OdfLeaderStyleType
     */
    public OdfLeaderStyleType getLeaderStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-style" ) );
        return OdfLeaderStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:leader-style}.
     *
     *@param  leaderStyle    the attribute's type is OdfLeaderStyleType
     */ 
     public void setLeaderStyle( OdfLeaderStyleType leaderStyle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-style" ), leaderStyle.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:leader-width}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getLeaderWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-width" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:leader-width}.
     *
     *@param  leaderWidth    the attribute's type is OdfPositiveInteger
     */ 
     public void setLeaderWidth( OdfPositiveInteger leaderWidth )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-width" ), leaderWidth.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:leader-color}.
     *
     *@return return the attribute which type is String
     */
    public String getLeaderColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-color" ) );
    }

    /**
     * Set value of attribute {@attributeName style:leader-color}.
     *
     *@param  leaderColor    the attribute's type is String
     */ 
     public void setLeaderColor( String leaderColor )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-color" ), leaderColor );
    }

    /**
     * Get value of attribute {@attributeName style:leader-text}.
     *
     *@return return the attribute which type is String
     */
    public String getLeaderText()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-text" ) );
        if( stringVal.length()==0 )
        {
            stringVal = " ";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:leader-text}.
     *
     *@param  leaderText    the attribute's type is String
     */ 
     public void setLeaderText( String leaderText )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-text" ), leaderText );
    }

    /**
     * Get value of attribute {@attributeName style:leader-text-style}.
     *
     *@return return the attribute which type is String
     */
    public String getLeaderTextStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-text-style" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:leader-text-style}.
     *
     *@param  leaderTextStyle    the attribute's type is OdfStyleNameRef
     */ 
     public void setLeaderTextStyle( OdfStyleNameRef leaderTextStyle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "leader-text-style" ), leaderTextStyle.toString() );
    }

}
