/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;

import org.odftoolkit.odfdom.dom.type.chart.OdfSymbolNameType;
import org.odftoolkit.odfdom.dom.type.chart.OdfSymbolNameType;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:style}.
 *
 */
public abstract class OdfStyleElement extends OdfStyleBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "style" );

    /**
     * Create the instance of OdfStyleElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfStyleElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:style}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfStyleElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *@param family  The mandatory attribute {@attributeName  style:family}" 
     *
     */
    public void init(OdfStyleName name, OdfStyleFamily family)
    {
        setName( name );
        setFamily( family );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName style:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName style:parent-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getParentStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "parent-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:parent-style-name}.
     *
     *@param  parentStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setParentStyleName( OdfStyleNameRef parentStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "parent-style-name" ), parentStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:next-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getNextStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "next-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:next-style-name}.
     *
     *@param  nextStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setNextStyleName( OdfStyleNameRef nextStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "next-style-name" ), nextStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:list-level}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getListLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "list-level" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:list-level}.
     *
     *@param  listLevel    the attribute's type is OdfPositiveInteger
     */ 
     public void setListLevel( OdfPositiveInteger listLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "list-level" ), listLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:list-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getListStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "list-style-name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:list-style-name}.
     *
     *@param  listStyleName    the attribute's type is OdfStyleName
     */ 
     public void setListStyleName( OdfStyleName listStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "list-style-name" ), listStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:master-page-name}.
     *
     *@return return the attribute which type is String
     */
    public String getMasterPageName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "master-page-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:master-page-name}.
     *
     *@param  masterPageName    the attribute's type is OdfStyleNameRef
     */ 
     public void setMasterPageName( OdfStyleNameRef masterPageName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "master-page-name" ), masterPageName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:auto-update}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getAutoUpdate()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "auto-update" ) );
        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:auto-update}.
     *
     *@param  isAutoUpdate    the attribute's type is OdfBoolean
     */ 
     public void setAutoUpdate( OdfBoolean isAutoUpdate )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "auto-update" ), isAutoUpdate.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:data-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDataStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:data-style-name}.
     *
     *@param  dataStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDataStyleName( OdfStyleNameRef dataStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "data-style-name" ), dataStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:percentage-data-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getPercentageDataStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "percentage-data-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:percentage-data-style-name}.
     *
     *@param  percentageDataStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setPercentageDataStyleName( OdfStyleNameRef percentageDataStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "percentage-data-style-name" ), percentageDataStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:class}.
     *
     *@return return the attribute which type is String
     */
    public String getStyleClass()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "class" ) );
    }

    /**
     * Set value of attribute {@attributeName style:class}.
     *
     *@param  styleClass    the attribute's type is String
     */ 
     public void setStyleClass( String styleClass )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "class" ), styleClass );
    }

    /**
     * Get value of attribute {@attributeName style:default-outline-level}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getDefaultOutlineLevel()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "default-outline-level" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:default-outline-level}.
     *
     *@param  defaultOutlineLevel    the attribute's type is OdfPositiveInteger
     */ 
     public void setDefaultOutlineLevel( OdfPositiveInteger defaultOutlineLevel )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "default-outline-level" ), defaultOutlineLevel.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:family}.
     *
     *@return return the attribute which type is OdfStyleFamily
     */
    public OdfStyleFamily getFamily()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "family" ) );
        return OdfStyleFamily.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:family}.
     *
     *@param  family    the attribute's type is OdfStyleFamily
     */ 
     public void setFamily( OdfStyleFamily family )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "family" ), family.toString() );
    }

    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
    /**
    * Create child element {@odfLink style:text-properties}.
    *
    *@param display String   
    *@param condition String   
    *@return   return  the element {@odfLink style:text-properties}
    */
    public OdfTextPropertiesElement createTextPropertiesElement(String   display, String   condition)
    {
        OdfTextPropertiesElement  nTextProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTextPropertiesElement.class);
        this.appendChild( nTextProperties);
        return  nTextProperties;      
    }
    
    /**
    * Create child element {@odfLink style:paragraph-properties}.
    *
    *@return   return  the element {@odfLink style:paragraph-properties}
    */
    public OdfParagraphPropertiesElement createParagraphPropertiesElement()
    {
        OdfParagraphPropertiesElement  nParagraphProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphPropertiesElement.class);
        this.appendChild( nParagraphProperties);
        return  nParagraphProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:section-properties}.
    *
    *@return   return  the element {@odfLink style:section-properties}
    */
    public OdfSectionPropertiesElement createSectionPropertiesElement()
    {
        OdfSectionPropertiesElement  nSectionProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSectionPropertiesElement.class);
        this.appendChild( nSectionProperties);
        return  nSectionProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:ruby-properties}.
    *
    *@return   return  the element {@odfLink style:ruby-properties}
    */
    public OdfRubyPropertiesElement createRubyPropertiesElement()
    {
        OdfRubyPropertiesElement  nRubyProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRubyPropertiesElement.class);
        this.appendChild( nRubyProperties);
        return  nRubyProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:table-properties}.
    *
    *@return   return  the element {@odfLink style:table-properties}
    */
    public OdfTablePropertiesElement createTablePropertiesElement()
    {
        OdfTablePropertiesElement  nTableProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTablePropertiesElement.class);
        this.appendChild( nTableProperties);
        return  nTableProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:table-column-properties}.
    *
    *@return   return  the element {@odfLink style:table-column-properties}
    */
    public OdfTableColumnPropertiesElement createTableColumnPropertiesElement()
    {
        OdfTableColumnPropertiesElement  nTableColumnProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableColumnPropertiesElement.class);
        this.appendChild( nTableColumnProperties);
        return  nTableColumnProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:table-row-properties}.
    *
    *@return   return  the element {@odfLink style:table-row-properties}
    */
    public OdfTableRowPropertiesElement createTableRowPropertiesElement()
    {
        OdfTableRowPropertiesElement  nTableRowProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableRowPropertiesElement.class);
        this.appendChild( nTableRowProperties);
        return  nTableRowProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:table-cell-properties}.
    *
    *@return   return  the element {@odfLink style:table-cell-properties}
    */
    public OdfTableCellPropertiesElement createTableCellPropertiesElement()
    {
        OdfTableCellPropertiesElement  nTableCellProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableCellPropertiesElement.class);
        this.appendChild( nTableCellProperties);
        return  nTableCellProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:graphic-properties}.
    *
    *@return   return  the element {@odfLink style:graphic-properties}
    */
    public OdfGraphicPropertiesElement createGraphicPropertiesElement()
    {
        OdfGraphicPropertiesElement  nGraphicProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGraphicPropertiesElement.class);
        this.appendChild( nGraphicProperties);
        return  nGraphicProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:drawing-page-properties}.
    *
    *@return   return  the element {@odfLink style:drawing-page-properties}
    */
    public OdfDrawingPagePropertiesElement createDrawingPagePropertiesElement()
    {
        OdfDrawingPagePropertiesElement  nDrawingPageProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDrawingPagePropertiesElement.class);
        this.appendChild( nDrawingPageProperties);
        return  nDrawingPageProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:chart-properties}.
    *
    *@param symbolType String   
    *@return   return  the element {@odfLink style:chart-properties}
    */
    public OdfChartPropertiesElement createChartPropertiesElement(String   symbolType)
    {
        OdfChartPropertiesElement  nChartProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChartPropertiesElement.class);
        this.appendChild( nChartProperties);
        return  nChartProperties;      
    }
    
    /**
    * Create child element {@odfLink style:chart-properties}.
    *
    *@param symbolType String   
    *@param symbolName     the attribute's type is OdfSymbolNameType, see {@attributeName  chart:symbol-name} at specification
    *@return   return  the element {@odfLink style:chart-properties}
    */
    public OdfChartPropertiesElement createChartPropertiesElement(String   symbolType, OdfSymbolNameType   symbolName)
    {
        OdfChartPropertiesElement  nChartProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChartPropertiesElement.class);
        this.appendChild( nChartProperties);
        return  nChartProperties;      
    }
    
    /**
    * Create child element {@odfLink style:map}.
    *
    *@param condition String   
    *@param applyStyleName  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleNameRef
    *@return   return  the element {@odfLink style:map}
    */
    public OdfMapElement createMapElement(String   condition, org.odftoolkit.odfdom.dom.type.OdfStyleNameRef   applyStyleName)
    {
        OdfMapElement  nMap = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfMapElement.class);
        nMap.setCondition( condition);
        nMap.setApplyStyleName( applyStyleName);
        this.appendChild( nMap);
        return  nMap;      
    }
    
}
