/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

import org.odftoolkit.odfdom.dom.element.office.OdfBinaryDataElement;
import org.odftoolkit.odfdom.dom.element.text.OdfNotesConfigurationElement;
import org.odftoolkit.odfdom.dom.type.text.OdfNoteClassType;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:section-properties}.
 *
 */
public abstract class OdfSectionPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "section-properties" );

    /**
     * Create the instance of OdfSectionPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfSectionPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:section-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.SectionProperties, OdfName.get(OdfNamespace.FO, "background-color"));
    public final static OdfStyleProperty MarginLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.SectionProperties, OdfName.get(OdfNamespace.FO, "margin-left"));
    public final static OdfStyleProperty MarginRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.SectionProperties, OdfName.get(OdfNamespace.FO, "margin-right"));
    public final static OdfStyleProperty Protect = 
        OdfStyleProperty.get(OdfStylePropertiesSet.SectionProperties, OdfName.get(OdfNamespace.STYLE, "protect"));
    public final static OdfStyleProperty Editable = 
        OdfStyleProperty.get(OdfStylePropertiesSet.SectionProperties, OdfName.get(OdfNamespace.STYLE, "editable"));
    public final static OdfStyleProperty DontBalanceTextColumns = 
        OdfStyleProperty.get(OdfStylePropertiesSet.SectionProperties, OdfName.get(OdfNamespace.TEXT, "dont-balance-text-columns"));
    public final static OdfStyleProperty WritingMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.SectionProperties, OdfName.get(OdfNamespace.STYLE, "writing-mode"));

    /**
    * Create child element {@odfLink office:binary-data}.
    *
    *@return   return  the element {@odfLink office:binary-data}
    */
    public OdfBinaryDataElement createBinaryDataElement()
    {
        OdfBinaryDataElement  nBinaryData = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBinaryDataElement.class);
        this.appendChild( nBinaryData);
        return  nBinaryData;
    }                   
               
    /**
    * Create child element {@odfLink style:column-sep}.
    *
    *@param width  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink style:column-sep}
    */
    public OdfColumnSepElement createColumnSepElement(org.odftoolkit.odfdom.dom.type.OdfLength   width)
    {
        OdfColumnSepElement  nColumnSep = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnSepElement.class);
        nColumnSep.setWidth( width);
        this.appendChild( nColumnSep);
        return  nColumnSep;      
    }
    
    /**
    * Create child element {@odfLink style:column}.
    *
    *@param relWidth String   
    *@return   return  the element {@odfLink style:column}
    */
    public OdfColumnElement createColumnElement(String   relWidth)
    {
        OdfColumnElement  nColumn = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnElement.class);
        nColumn.setRelWidth( relWidth);
        this.appendChild( nColumn);
        return  nColumn;      
    }
    
    /**
    * Create child element {@odfLink text:notes-configuration}.
    *
    *@param noteClass     the attribute's type is OdfNoteClassType, see {@attributeName  text:note-class} at specification
    *@return   return  the element {@odfLink text:notes-configuration}
    */
    public OdfNotesConfigurationElement createNotesConfigurationElement(OdfNoteClassType   noteClass)
    {
        OdfNotesConfigurationElement  nNotesConfiguration = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNotesConfigurationElement.class);
        nNotesConfiguration.setNoteClass( noteClass);
        this.appendChild( nNotesConfiguration);
        return  nNotesConfiguration;      
    }
    
}
