/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;

import org.odftoolkit.odfdom.dom.element.presentation.OdfPlaceholderElement;
import org.odftoolkit.odfdom.dom.type.OdfPresentationClasses;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:presentation-page-layout}.
 *
 */
public abstract class OdfPresentationPageLayoutElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "presentation-page-layout" );

    /**
     * Create the instance of OdfPresentationPageLayoutElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPresentationPageLayoutElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:presentation-page-layout}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfPresentationPageLayoutElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName style:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ), displayName );
    }

    /**
    * Create child element {@odfLink presentation:placeholder}.
    *
    *@param object OdfPresentationClasses   
    *@param x  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param width  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param height  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink presentation:placeholder}
    */
    public OdfPlaceholderElement createPlaceholderElement(OdfPresentationClasses   object, org.odftoolkit.odfdom.dom.type.OdfLength   x, org.odftoolkit.odfdom.dom.type.OdfLength   y, org.odftoolkit.odfdom.dom.type.OdfLength   width, org.odftoolkit.odfdom.dom.type.OdfLength   height)
    {
        OdfPlaceholderElement  nPlaceholder = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPlaceholderElement.class);
        nPlaceholder.setObject( object);
        nPlaceholder.setX( x);
        nPlaceholder.setY( y);
        nPlaceholder.setWidth( width);
        nPlaceholder.setHeight( height);
        this.appendChild( nPlaceholder);
        return  nPlaceholder;      
    }
    
}
