/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

import org.odftoolkit.odfdom.dom.element.office.OdfBinaryDataElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:page-layout-properties}.
 *
 */
public abstract class OdfPageLayoutPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "page-layout-properties" );

    /**
     * Create the instance of OdfPageLayoutPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPageLayoutPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:page-layout-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty PageWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "page-width"));
    public final static OdfStyleProperty PageHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "page-height"));
    public final static OdfStyleProperty NumFormat = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "num-format"));
    public final static OdfStyleProperty NumLetterSync = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "num-letter-sync"));
    public final static OdfStyleProperty NumPrefix = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "num-prefix"));
    public final static OdfStyleProperty NumSuffix = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "num-suffix"));
    public final static OdfStyleProperty PaperTrayName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "paper-tray-name"));
    public final static OdfStyleProperty PrintOrientation = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "print-orientation"));
    public final static OdfStyleProperty MarginLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "margin-left"));
    public final static OdfStyleProperty MarginRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "margin-right"));
    public final static OdfStyleProperty MarginTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "margin-top"));
    public final static OdfStyleProperty MarginBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "margin-bottom"));
    public final static OdfStyleProperty Margin = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "margin"));
    public final static OdfStyleProperty Border = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "border"));
    public final static OdfStyleProperty BorderTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "border-top"));
    public final static OdfStyleProperty BorderBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "border-bottom"));
    public final static OdfStyleProperty BorderLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "border-left"));
    public final static OdfStyleProperty BorderRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "border-right"));
    public final static OdfStyleProperty BorderLineWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width"));
    public final static OdfStyleProperty BorderLineWidthTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-top"));
    public final static OdfStyleProperty BorderLineWidthBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-bottom"));
    public final static OdfStyleProperty BorderLineWidthLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-left"));
    public final static OdfStyleProperty BorderLineWidthRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-right"));
    public final static OdfStyleProperty Padding = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "padding"));
    public final static OdfStyleProperty PaddingTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "padding-top"));
    public final static OdfStyleProperty PaddingBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "padding-bottom"));
    public final static OdfStyleProperty PaddingLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "padding-left"));
    public final static OdfStyleProperty PaddingRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "padding-right"));
    public final static OdfStyleProperty Shadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "shadow"));
    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.FO, "background-color"));
    public final static OdfStyleProperty RegisterTruthRefStyleName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "register-truth-ref-style-name"));
    public final static OdfStyleProperty Print = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "print"));
    public final static OdfStyleProperty PrintPageOrder = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "print-page-order"));
    public final static OdfStyleProperty FirstPageNumber = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "first-page-number"));
    public final static OdfStyleProperty ScaleTo = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "scale-to"));
    public final static OdfStyleProperty ScaleToPages = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "scale-to-pages"));
    public final static OdfStyleProperty TableCentering = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "table-centering"));
    public final static OdfStyleProperty FootnoteMaxHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "footnote-max-height"));
    public final static OdfStyleProperty WritingMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "writing-mode"));
    public final static OdfStyleProperty LayoutGridMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-mode"));
    public final static OdfStyleProperty LayoutGridStandardMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-standard-mode"));
    public final static OdfStyleProperty LayoutGridBaseHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-base-height"));
    public final static OdfStyleProperty LayoutGridRubyHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-ruby-height"));
    public final static OdfStyleProperty LayoutGridLines = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-lines"));
    public final static OdfStyleProperty LayoutGridBaseWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-base-width"));
    public final static OdfStyleProperty LayoutGridColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-color"));
    public final static OdfStyleProperty LayoutGridRubyBelow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-ruby-below"));
    public final static OdfStyleProperty LayoutGridPrint = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-print"));
    public final static OdfStyleProperty LayoutGridDisplay = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-display"));
    public final static OdfStyleProperty LayoutGridSnapTo = 
        OdfStyleProperty.get(OdfStylePropertiesSet.PageLayoutProperties, OdfName.get(OdfNamespace.STYLE, "layout-grid-snap-to"));

    /**
    * Create child element {@odfLink office:binary-data}.
    *
    *@return   return  the element {@odfLink office:binary-data}
    */
    public OdfBinaryDataElement createBinaryDataElement()
    {
        OdfBinaryDataElement  nBinaryData = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBinaryDataElement.class);
        this.appendChild( nBinaryData);
        return  nBinaryData;
    }                   
               
    /**
    * Create child element {@odfLink style:column-sep}.
    *
    *@param width  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink style:column-sep}
    */
    public OdfColumnSepElement createColumnSepElement(org.odftoolkit.odfdom.dom.type.OdfLength   width)
    {
        OdfColumnSepElement  nColumnSep = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnSepElement.class);
        nColumnSep.setWidth( width);
        this.appendChild( nColumnSep);
        return  nColumnSep;      
    }
    
    /**
    * Create child element {@odfLink style:column}.
    *
    *@param relWidth String   
    *@return   return  the element {@odfLink style:column}
    */
    public OdfColumnElement createColumnElement(String   relWidth)
    {
        OdfColumnElement  nColumn = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnElement.class);
        nColumn.setRelWidth( relWidth);
        this.appendChild( nColumn);
        return  nColumn;      
    }
    
}
