/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.style.OdfPageUsageType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:page-layout}.
 *
 */
public abstract class OdfPageLayoutElement extends OdfStyleBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "page-layout" );

    /**
     * Create the instance of OdfPageLayoutElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfPageLayoutElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:page-layout}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfPageLayoutElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *
     */
    public void init(OdfStyleName name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:page-usage}.
     *
     *@return return the attribute which type is OdfPageUsageType
     */
    public OdfPageUsageType getPageUsage()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "page-usage" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "all";
        }

        return OdfPageUsageType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:page-usage}.
     *
     *@param  pageUsage    the attribute's type is OdfPageUsageType
     */ 
     public void setPageUsage( OdfPageUsageType pageUsage )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "page-usage" ), pageUsage.toString() );
    }

    /**
    * Create child element {@odfLink style:page-layout-properties}.
    *
    *@return   return  the element {@odfLink style:page-layout-properties}
    */
    public OdfPageLayoutPropertiesElement createPageLayoutPropertiesElement()
    {
        OdfPageLayoutPropertiesElement  nPageLayoutProperties = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageLayoutPropertiesElement.class);
        this.appendChild( nPageLayoutProperties);
        return  nPageLayoutProperties;
    }                   
               
    /**
    * Create child element {@odfLink style:header-style}.
    *
    *@return   return  the element {@odfLink style:header-style}
    */
    public OdfHeaderStyleElement createHeaderStyleElement()
    {
        OdfHeaderStyleElement  nHeaderStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeaderStyleElement.class);
        this.appendChild( nHeaderStyle);
        return  nHeaderStyle;
    }                   
               
    /**
    * Create child element {@odfLink style:footer-style}.
    *
    *@return   return  the element {@odfLink style:footer-style}
    */
    public OdfFooterStyleElement createFooterStyleElement()
    {
        OdfFooterStyleElement  nFooterStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFooterStyleElement.class);
        this.appendChild( nFooterStyle);
        return  nFooterStyle;
    }                   
               
}
