/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleName;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;

import org.odftoolkit.odfdom.dom.element.draw.OdfLayerSetElement;
import org.odftoolkit.odfdom.dom.element.form.OdfFormElement;
import org.odftoolkit.odfdom.dom.element.xforms.OdfModelElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRectElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfLineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolylineElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfRegularPolygonElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPathElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCircleElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfEllipseElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfGroupElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfPageThumbnailElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfFrameElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCaptionElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfConnectorElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfControlElement;
import org.odftoolkit.odfdom.dom.element.dr3d.OdfSceneElement;
import org.odftoolkit.odfdom.dom.element.draw.OdfCustomShapeElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.element.anim.OdfAnimateElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfSetElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfAnimateMotionElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfAnimateColorElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfAnimateTransformElement;
import org.odftoolkit.odfdom.dom.type.svg.OdfType;
import org.odftoolkit.odfdom.dom.element.anim.OdfTransitionFilterElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfParElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfSeqElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfIterateElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfAudioElement;
import org.odftoolkit.odfdom.dom.element.anim.OdfCommandElement;
import org.odftoolkit.odfdom.dom.element.presentation.OdfNotesElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:master-page}.
 *
 */
public abstract class OdfMasterPageElement extends OdfStylableElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "master-page" );

    /**
     * Create the instance of OdfMasterPageElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfMasterPageElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME, OdfStyleFamily.DrawingPage, OdfName.get( OdfNamespace.DRAW, "style-name" ) );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:master-page}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfMasterPageElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *@param pageLayoutName  The mandatory attribute {@attributeName  style:page-layout-name}" 
     *
     */
    public void init(OdfStyleName name, OdfStyleNameRef pageLayoutName)
    {
        setName( name );
        setPageLayoutName( pageLayoutName );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
        return OdfStyleName.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is OdfStyleName
     */ 
     public void setName( OdfStyleName name )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:display-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDisplayName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ) );
    }

    /**
     * Set value of attribute {@attributeName style:display-name}.
     *
     *@param  displayName    the attribute's type is String
     */ 
     public void setDisplayName( String displayName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display-name" ), displayName );
    }

    /**
     * Get value of attribute {@attributeName style:page-layout-name}.
     *
     *@return return the attribute which type is String
     */
    public String getPageLayoutName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "page-layout-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:page-layout-name}.
     *
     *@param  pageLayoutName    the attribute's type is OdfStyleNameRef
     */ 
     public void setPageLayoutName( OdfStyleNameRef pageLayoutName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "page-layout-name" ), pageLayoutName.toString() );
    }

    /**
     * Get value of attribute {@attributeName draw:style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getDrawStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:style-name}.
     *
     *@param  drawStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setDrawStyleName( OdfStyleNameRef drawStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "style-name" ), drawStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:next-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getNextStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "next-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:next-style-name}.
     *
     *@param  nextStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setNextStyleName( OdfStyleNameRef nextStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "next-style-name" ), nextStyleName.toString() );
    }

    /**
    * Create child element {@odfLink style:header}.
    *
    *@return   return  the element {@odfLink style:header}
    */
    public OdfHeaderElement createHeaderElement()
    {
        OdfHeaderElement  nHeader = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeaderElement.class);
        this.appendChild( nHeader);
        return  nHeader;
    }                   
               
    /**
    * Create child element {@odfLink style:header-left}.
    *
    *@return   return  the element {@odfLink style:header-left}
    */
    public OdfHeaderLeftElement createHeaderLeftElement()
    {
        OdfHeaderLeftElement  nHeaderLeft = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeaderLeftElement.class);
        this.appendChild( nHeaderLeft);
        return  nHeaderLeft;
    }                   
               
    /**
    * Create child element {@odfLink style:footer}.
    *
    *@return   return  the element {@odfLink style:footer}
    */
    public OdfFooterElement createFooterElement()
    {
        OdfFooterElement  nFooter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFooterElement.class);
        this.appendChild( nFooter);
        return  nFooter;
    }                   
               
    /**
    * Create child element {@odfLink style:footer-left}.
    *
    *@return   return  the element {@odfLink style:footer-left}
    */
    public OdfFooterLeftElement createFooterLeftElement()
    {
        OdfFooterLeftElement  nFooterLeft = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFooterLeftElement.class);
        this.appendChild( nFooterLeft);
        return  nFooterLeft;
    }                   
               
    /**
    * Create child element {@odfLink draw:layer-set}.
    *
    *@return   return  the element {@odfLink draw:layer-set}
    */
    public OdfLayerSetElement createLayerSetElement()
    {
        OdfLayerSetElement  nLayerSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLayerSetElement.class);
        this.appendChild( nLayerSet);
        return  nLayerSet;
    }                   
               
    /**
    * Create child element {@odfLink form:form}.
    *
    *@return   return  the element {@odfLink form:form}
    */
    public OdfFormElement createFormElement()
    {
        OdfFormElement  nForm = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFormElement.class);
        this.appendChild( nForm);
        return  nForm;
    }                   
               
    /**
    * Create child element {@odfLink xforms:model}.
    *
    *@return   return  the element {@odfLink xforms:model}
    */
    public OdfModelElement createModelElement()
    {
        OdfModelElement  nModel = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfModelElement.class);
        this.appendChild( nModel);
        return  nModel;
    }                   
               
    /**
    * Create child element {@odfLink style:style}.
    *
    *@param name  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfStyleName
    *@return   return  the element {@odfLink style:style}
    */
    public OdfStyleElement createStyleElement(org.odftoolkit.odfdom.dom.type.OdfStyleName   name)
    {
        OdfStyleElement  nStyle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfStyleElement.class);
        nStyle.setName( name);
        this.appendChild( nStyle);
        return  nStyle;      
    }
    
    /**
    * Create child element {@odfLink draw:rect}.
    *
    *@return   return  the element {@odfLink draw:rect}
    */
    public OdfRectElement createRectElement()
    {
        OdfRectElement  nRect = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRectElement.class);
        this.appendChild( nRect);
        return  nRect;
    }                   
               
    /**
    * Create child element {@odfLink draw:line}.
    *
    *@param x1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y1  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param x2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@param y2  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink draw:line}
    */
    public OdfLineElement createLineElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        OdfLineElement  nLine = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfLineElement.class);
        nLine.setX1( x1);
        nLine.setY1( y1);
        nLine.setX2( x2);
        nLine.setY2( y2);
        this.appendChild( nLine);
        return  nLine;      
    }
    
    /**
    * Create child element {@odfLink draw:polyline}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polyline}
    */
    public OdfPolylineElement createPolylineElement(String   points, Integer   viewBox)
    {
        OdfPolylineElement  nPolyline = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolylineElement.class);
        nPolyline.setPoints( points);
        nPolyline.setViewBox( viewBox);
        this.appendChild( nPolyline);
        return  nPolyline;      
    }
    
    /**
    * Create child element {@odfLink draw:polygon}.
    *
    *@param points String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:polygon}
    */
    public OdfPolygonElement createPolygonElement(String   points, Integer   viewBox)
    {
        OdfPolygonElement  nPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPolygonElement.class);
        nPolygon.setPoints( points);
        nPolygon.setViewBox( viewBox);
        this.appendChild( nPolygon);
        return  nPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@param concave   the attribute's type is Boolean
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners, org.odftoolkit.odfdom.dom.type.OdfBoolean   concave)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setCorners( corners);
        nRegularPolygon.setConcave( concave);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:regular-polygon}.
    *
    *@param concave   the attribute's type is Boolean
    *@param corners  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink draw:regular-polygon}
    */
    public OdfRegularPolygonElement createRegularPolygonElement(org.odftoolkit.odfdom.dom.type.OdfBoolean   concave, org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   corners)
    {
        OdfRegularPolygonElement  nRegularPolygon = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegularPolygonElement.class);
        nRegularPolygon.setConcave( concave);
        nRegularPolygon.setCorners( corners);
        this.appendChild( nRegularPolygon);
        return  nRegularPolygon;      
    }
    
    /**
    * Create child element {@odfLink draw:path}.
    *
    *@param d String   
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:path}
    */
    public OdfPathElement createPathElement(String   d, Integer   viewBox)
    {
        OdfPathElement  nPath = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPathElement.class);
        nPath.setD( d);
        nPath.setViewBox( viewBox);
        this.appendChild( nPath);
        return  nPath;      
    }
    
    /**
    * Create child element {@odfLink draw:circle}.
    *
    *@return   return  the element {@odfLink draw:circle}
    */
    public OdfCircleElement createCircleElement()
    {
        OdfCircleElement  nCircle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCircleElement.class);
        this.appendChild( nCircle);
        return  nCircle;
    }                   
               
    /**
    * Create child element {@odfLink draw:ellipse}.
    *
    *@return   return  the element {@odfLink draw:ellipse}
    */
    public OdfEllipseElement createEllipseElement()
    {
        OdfEllipseElement  nEllipse = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfEllipseElement.class);
        this.appendChild( nEllipse);
        return  nEllipse;
    }                   
               
    /**
    * Create child element {@odfLink draw:g}.
    *
    *@return   return  the element {@odfLink draw:g}
    */
    public OdfGroupElement createGroupElement()
    {
        OdfGroupElement  nGroup = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfGroupElement.class);
        this.appendChild( nGroup);
        return  nGroup;
    }                   
               
    /**
    * Create child element {@odfLink draw:page-thumbnail}.
    *
    *@return   return  the element {@odfLink draw:page-thumbnail}
    */
    public OdfPageThumbnailElement createPageThumbnailElement()
    {
        OdfPageThumbnailElement  nPageThumbnail = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfPageThumbnailElement.class);
        this.appendChild( nPageThumbnail);
        return  nPageThumbnail;
    }                   
               
    /**
    * Create child element {@odfLink draw:frame}.
    *
    *@return   return  the element {@odfLink draw:frame}
    */
    public OdfFrameElement createFrameElement()
    {
        OdfFrameElement  nFrame = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFrameElement.class);
        this.appendChild( nFrame);
        return  nFrame;
    }                   
               
    /**
    * Create child element {@odfLink draw:measure}.
    *
    *@param x1  the attribute's type is String
    *@param y1  the attribute's type is String
    *@param x2  the attribute's type is String
    *@param y2  the attribute's type is String
    *@return   return  the element {@odfLink draw:measure}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement createdrawMeasureElement(org.odftoolkit.odfdom.dom.type.OdfLength   x1, org.odftoolkit.odfdom.dom.type.OdfLength   y1, org.odftoolkit.odfdom.dom.type.OdfLength   x2, org.odftoolkit.odfdom.dom.type.OdfLength   y2)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement  nMeasure = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfMeasureElement.class);
        nMeasure.setX1( x1);
        nMeasure.setY1( y1);
        nMeasure.setX2( x2);
        nMeasure.setY2( y2);
        this.appendChild( nMeasure);
        return  nMeasure;      
    }
    
    /**
    * Create child element {@odfLink draw:caption}.
    *
    *@return   return  the element {@odfLink draw:caption}
    */
    public OdfCaptionElement createCaptionElement()
    {
        OdfCaptionElement  nCaption = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCaptionElement.class);
        this.appendChild( nCaption);
        return  nCaption;
    }                   
               
    /**
    * Create child element {@odfLink draw:connector}.
    *
    *@param viewBox Integer   
    *@return   return  the element {@odfLink draw:connector}
    */
    public OdfConnectorElement createConnectorElement(Integer   viewBox)
    {
        OdfConnectorElement  nConnector = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfConnectorElement.class);
        nConnector.setViewBox( viewBox);
        this.appendChild( nConnector);
        return  nConnector;      
    }
    
    /**
    * Create child element {@odfLink draw:control}.
    *
    *@param control  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfId
    *@return   return  the element {@odfLink draw:control}
    */
    public OdfControlElement createControlElement(org.odftoolkit.odfdom.dom.type.OdfId   control)
    {
        OdfControlElement  nControl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfControlElement.class);
        nControl.setControl( control);
        this.appendChild( nControl);
        return  nControl;      
    }
    
    /**
    * Create child element {@odfLink dr3d:scene}.
    *
    *@return   return  the element {@odfLink dr3d:scene}
    */
    public OdfSceneElement createSceneElement()
    {
        OdfSceneElement  nScene = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSceneElement.class);
        this.appendChild( nScene);
        return  nScene;
    }                   
               
    /**
    * Create child element {@odfLink draw:custom-shape}.
    *
    *@return   return  the element {@odfLink draw:custom-shape}
    */
    public OdfCustomShapeElement createCustomShapeElement()
    {
        OdfCustomShapeElement  nCustomShape = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCustomShapeElement.class);
        this.appendChild( nCustomShape);
        return  nCustomShape;
    }                   
               
    /**
    * Create child element {@odfLink draw:a}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink draw:a}
    */
    public org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement createdrawHyperlinkElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement  nHyperlink = ((OdfFileDom)this.ownerDocument).createOdfElement(org.odftoolkit.odfdom.dom.element.draw.OdfHyperlinkElement.class);
        nHyperlink.setHref( href);
        this.appendChild( nHyperlink);
        return  nHyperlink;      
    }
    
    /**
    * Create child element {@odfLink anim:animate}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:animate}
    */
    public OdfAnimateElement createAnimateElement(String   attributeName)
    {
        OdfAnimateElement  nAnimate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateElement.class);
        nAnimate.setAttributeName( attributeName);
        this.appendChild( nAnimate);
        return  nAnimate;      
    }
    
    /**
    * Create child element {@odfLink anim:set}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:set}
    */
    public OdfSetElement createSetElement(String   attributeName)
    {
        OdfSetElement  nSet = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSetElement.class);
        nSet.setAttributeName( attributeName);
        this.appendChild( nSet);
        return  nSet;      
    }
    
    /**
    * Create child element {@odfLink anim:animateMotion}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:animateMotion}
    */
    public OdfAnimateMotionElement createAnimateMotionElement(String   attributeName)
    {
        OdfAnimateMotionElement  nAnimateMotion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateMotionElement.class);
        nAnimateMotion.setAttributeName( attributeName);
        this.appendChild( nAnimateMotion);
        return  nAnimateMotion;      
    }
    
    /**
    * Create child element {@odfLink anim:animateColor}.
    *
    *@param attributeName String   
    *@return   return  the element {@odfLink anim:animateColor}
    */
    public OdfAnimateColorElement createAnimateColorElement(String   attributeName)
    {
        OdfAnimateColorElement  nAnimateColor = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateColorElement.class);
        nAnimateColor.setAttributeName( attributeName);
        this.appendChild( nAnimateColor);
        return  nAnimateColor;      
    }
    
    /**
    * Create child element {@odfLink anim:animateTransform}.
    *
    *@param attributeName String   
    *@param type   the attribute's type is OdfType, see {@attributeName  svg:type} at specification
    *@return   return  the element {@odfLink anim:animateTransform}
    */
    public OdfAnimateTransformElement createAnimateTransformElement(String   attributeName, OdfType   type)
    {
        OdfAnimateTransformElement  nAnimateTransform = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAnimateTransformElement.class);
        nAnimateTransform.setAttributeName( attributeName);
        nAnimateTransform.setType( type);
        this.appendChild( nAnimateTransform);
        return  nAnimateTransform;      
    }
    
    /**
    * Create child element {@odfLink anim:transitionFilter}.
    *
    *@param type String   
    *@return   return  the element {@odfLink anim:transitionFilter}
    */
    public OdfTransitionFilterElement createTransitionFilterElement(String   type)
    {
        OdfTransitionFilterElement  nTransitionFilter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTransitionFilterElement.class);
        nTransitionFilter.setType( type);
        this.appendChild( nTransitionFilter);
        return  nTransitionFilter;      
    }
    
    /**
    * Create child element {@odfLink anim:par}.
    *
    *@return   return  the element {@odfLink anim:par}
    */
    public OdfParElement createParElement()
    {
        OdfParElement  nPar = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParElement.class);
        this.appendChild( nPar);
        return  nPar;
    }                   
               
    /**
    * Create child element {@odfLink anim:seq}.
    *
    *@return   return  the element {@odfLink anim:seq}
    */
    public OdfSeqElement createSeqElement()
    {
        OdfSeqElement  nSeq = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSeqElement.class);
        this.appendChild( nSeq);
        return  nSeq;
    }                   
               
    /**
    * Create child element {@odfLink anim:iterate}.
    *
    *@return   return  the element {@odfLink anim:iterate}
    */
    public OdfIterateElement createIterateElement()
    {
        OdfIterateElement  nIterate = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIterateElement.class);
        this.appendChild( nIterate);
        return  nIterate;
    }                   
               
    /**
    * Create child element {@odfLink anim:audio}.
    *
    *@return   return  the element {@odfLink anim:audio}
    */
    public OdfAudioElement createAudioElement()
    {
        OdfAudioElement  nAudio = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAudioElement.class);
        this.appendChild( nAudio);
        return  nAudio;
    }                   
               
    /**
    * Create child element {@odfLink anim:command}.
    *
    *@param command String   
    *@return   return  the element {@odfLink anim:command}
    */
    public OdfCommandElement createCommandElement(String   command)
    {
        OdfCommandElement  nCommand = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfCommandElement.class);
        nCommand.setCommand( command);
        this.appendChild( nCommand);
        return  nCommand;      
    }
    
    /**
    * Create child element {@odfLink presentation:notes}.
    *
    *@return   return  the element {@odfLink presentation:notes}
    */
    public OdfNotesElement createNotesElement()
    {
        OdfNotesElement  nNotes = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfNotesElement.class);
        this.appendChild( nNotes);
        return  nNotes;
    }                   
               
}
