/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfStyleNameRef;
import org.odftoolkit.odfdom.dom.type.OdfCellAddress;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:map}.
 *
 */
public abstract class OdfMapElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "map" );

    /**
     * Create the instance of OdfMapElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfMapElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:map}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfMapElement}
     *
     *@param condition  The mandatory attribute {@attributeName  style:condition}" 
     *@param applyStyleName  The mandatory attribute {@attributeName  style:apply-style-name}" 
     *
     */
    public void init(String condition, OdfStyleNameRef applyStyleName)
    {
        setCondition( condition );
        setApplyStyleName( applyStyleName );
    }

    /**
     * Get value of attribute {@attributeName style:condition}.
     *
     *@return return the attribute which type is String
     */
    public String getCondition()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "condition" ) );
    }

    /**
     * Set value of attribute {@attributeName style:condition}.
     *
     *@param  condition    the attribute's type is String
     */ 
     public void setCondition( String condition )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "condition" ), condition );
    }

    /**
     * Get value of attribute {@attributeName style:apply-style-name}.
     *
     *@return return the attribute which type is String
     */
    public String getApplyStyleName()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "apply-style-name" ) );
        return OdfStyleNameRef.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:apply-style-name}.
     *
     *@param  applyStyleName    the attribute's type is OdfStyleNameRef
     */ 
     public void setApplyStyleName( OdfStyleNameRef applyStyleName )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "apply-style-name" ), applyStyleName.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:base-cell-address}.
     *
     *@return return the attribute which type is OdfCellAddress
     */
    public OdfCellAddress getBaseCellAddress()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "base-cell-address" ) );
        return OdfCellAddress.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:base-cell-address}.
     *
     *@param  baseCellAddress    the attribute's type is OdfCellAddress
     */ 
     public void setBaseCellAddress( OdfCellAddress baseCellAddress )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "base-cell-address" ), baseCellAddress.toString() );
    }

}
