/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:list-level-properties}.
 *
 */
public abstract class OdfListLevelPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "list-level-properties" );

    /**
     * Create the instance of OdfListLevelPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfListLevelPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:list-level-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty TextAlign = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.FO, "text-align"));
    public final static OdfStyleProperty SpaceBefore = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.TEXT, "space-before"));
    public final static OdfStyleProperty MinLabelWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.TEXT, "min-label-width"));
    public final static OdfStyleProperty MinLabelDistance = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.TEXT, "min-label-distance"));
    public final static OdfStyleProperty FontName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.STYLE, "font-name"));
    public final static OdfStyleProperty Width = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.FO, "width"));
    public final static OdfStyleProperty Height = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.FO, "height"));
    public final static OdfStyleProperty VerticalRel = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.STYLE, "vertical-rel"));
    public final static OdfStyleProperty VerticalPos = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.STYLE, "vertical-pos"));
    public final static OdfStyleProperty Y = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.SVG, "y"));
    public final static OdfStyleProperty ListLevelPositionAndSpaceMode = 
        OdfStyleProperty.get(OdfStylePropertiesSet.ListLevelProperties, OdfName.get(OdfNamespace.TEXT, "list-level-position-and-space-mode"));

}
