/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.text.OdfLabelFollowedByType;
import org.odftoolkit.odfdom.dom.type.OdfNonNegativeLength;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:list-level-label-alignment}.
 *
 */
public abstract class OdfListLevelLabelAlignmentElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "list-level-label-alignment" );

    /**
     * Create the instance of OdfListLevelLabelAlignmentElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfListLevelLabelAlignmentElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:list-level-label-alignment}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfListLevelLabelAlignmentElement}
     *
     *@param labelFollowedBy  The mandatory attribute {@attributeName  text:label-followed-by}" 
     *
     */
    public void init(OdfLabelFollowedByType labelFollowedBy)
    {
        setLabelFollowedBy( labelFollowedBy );
    }

    /**
     * Get value of attribute {@attributeName text:label-followed-by}.
     *
     *@return return the attribute which type is OdfLabelFollowedByType
     */
    public OdfLabelFollowedByType getLabelFollowedBy()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "label-followed-by" ) );
        return OdfLabelFollowedByType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:label-followed-by}.
     *
     *@param  labelFollowedBy    the attribute's type is OdfLabelFollowedByType
     */ 
     public void setLabelFollowedBy( OdfLabelFollowedByType labelFollowedBy )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "label-followed-by" ), labelFollowedBy.toString() );
    }

    /**
     * Get value of attribute {@attributeName text:list-tab-stop-position}.
     *
     *@return return the attribute which type is OdfNonNegativeLength
     */
    public OdfNonNegativeLength getListTabStopPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.TEXT, "list-tab-stop-position" ) );
        return OdfNonNegativeLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName text:list-tab-stop-position}.
     *
     *@param  listTabStopPosition    the attribute's type is OdfNonNegativeLength
     */ 
     public void setListTabStopPosition( OdfNonNegativeLength listTabStopPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.TEXT, "list-tab-stop-position" ), listTabStopPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:text-indent}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getTextIndent()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "text-indent" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:text-indent}.
     *
     *@param  textIndent    the attribute's type is OdfLength
     */ 
     public void setTextIndent( OdfLength textIndent )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "text-indent" ), textIndent.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:margin-left}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getMarginLeft()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "margin-left" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:margin-left}.
     *
     *@param  marginLeft    the attribute's type is OdfLength
     */ 
     public void setMarginLeft( OdfLength marginLeft )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "margin-left" ), marginLeft.toString() );
    }

}
