/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfBoolean;

import org.odftoolkit.odfdom.dom.element.text.OdfChangedRegionElement;
import org.odftoolkit.odfdom.dom.element.text.OdfVariableDeclElement;
import org.odftoolkit.odfdom.dom.type.office.OdfValueType;
import org.odftoolkit.odfdom.dom.element.text.OdfSequenceDeclElement;
import org.odftoolkit.odfdom.dom.element.text.OdfUserFieldDeclElement;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.datatype.Duration;
import org.odftoolkit.odfdom.dom.element.text.OdfDdeConnectionDeclElement;
import org.odftoolkit.odfdom.dom.element.text.OdfAlphabeticalIndexAutoMarkFileElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.element.text.OdfHeadingElement;
import org.odftoolkit.odfdom.dom.element.text.OdfParagraphElement;
import org.odftoolkit.odfdom.dom.element.text.OdfListElement;
import org.odftoolkit.odfdom.dom.element.table.OdfTableElement;
import org.odftoolkit.odfdom.dom.element.text.OdfSectionElement;
import org.odftoolkit.odfdom.dom.type.text.OdfSectionDisplayType;
import org.odftoolkit.odfdom.dom.element.text.OdfTableOfContentElement;
import org.odftoolkit.odfdom.dom.element.text.OdfIllustrationIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfTableIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfObjectIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfUserIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfAlphabeticalIndexElement;
import org.odftoolkit.odfdom.dom.element.text.OdfBibliographyElement;
import org.odftoolkit.odfdom.dom.element.text.OdfIndexTitleElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:header-left}.
 *
 */
public abstract class OdfHeaderLeftElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "header-left" );

    /**
     * Create the instance of OdfHeaderLeftElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfHeaderLeftElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:header-left}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName style:display}.
     *
     *@return return the attribute which type is OdfBoolean
     */
    public OdfBoolean getDisplay()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "true";
        }

        return OdfBoolean.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:display}.
     *
     *@param  isDisplay    the attribute's type is OdfBoolean
     */ 
     public void setDisplay( OdfBoolean isDisplay )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "display" ), isDisplay.toString() );
    }

    /**
    * Create child element {@odfLink text:changed-region}.
    *
    *@return   return  the element {@odfLink text:changed-region}
    */
    public OdfChangedRegionElement createChangedRegionElement()
    {
        OdfChangedRegionElement  nChangedRegion = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfChangedRegionElement.class);
        this.appendChild( nChangedRegion);
        return  nChangedRegion;
    }                   
               
    /**
    * Create child element {@odfLink text:variable-decl}.
    *
    *@param name String   
    *@param valueType     the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@return   return  the element {@odfLink text:variable-decl}
    */
    public OdfVariableDeclElement createVariableDeclElement(String   name, OdfValueType   valueType)
    {
        OdfVariableDeclElement  nVariableDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfVariableDeclElement.class);
        nVariableDecl.setName( name);
        nVariableDecl.setValueType( valueType);
        this.appendChild( nVariableDecl);
        return  nVariableDecl;      
    }
    
    /**
    * Create child element {@odfLink text:sequence-decl}.
    *
    *@param name String   
    *@param displayOutlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger
    *@return   return  the element {@odfLink text:sequence-decl}
    */
    public OdfSequenceDeclElement createSequenceDeclElement(String   name, org.odftoolkit.odfdom.dom.type.OdfNonNegativeInteger   displayOutlineLevel)
    {
        OdfSequenceDeclElement  nSequenceDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSequenceDeclElement.class);
        nSequenceDecl.setName( name);
        nSequenceDecl.setDisplayOutlineLevel( displayOutlineLevel);
        this.appendChild( nSequenceDecl);
        return  nSequenceDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param value Double   
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, Double   value, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setValue( value);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param dateValue    the attribute's type is XMLGregorianCalendar
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDate   dateValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setDateValue( dateValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param timeValue    the attribute's type is Duration
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfDuration   timeValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setTimeValue( timeValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param booleanValue  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfBoolean
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, org.odftoolkit.odfdom.dom.type.OdfBoolean   booleanValue, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setBooleanValue( booleanValue);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:user-field-decl}.
    *
    *@param valueType   the attribute's type is OdfValueType, see {@attributeName  office:value} at specification
    *@param name String   
    *@return   return  the element {@odfLink text:user-field-decl}
    */
    public OdfUserFieldDeclElement createUserFieldDeclElement(OdfValueType   valueType, String   name)
    {
        OdfUserFieldDeclElement  nUserFieldDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserFieldDeclElement.class);
        nUserFieldDecl.setValueType( valueType);
        nUserFieldDecl.setName( name);
        this.appendChild( nUserFieldDecl);
        return  nUserFieldDecl;      
    }
    
    /**
    * Create child element {@odfLink text:dde-connection-decl}.
    *
    *@param name String   
    *@param ddeApplication String   
    *@param ddeTopic String   
    *@param ddeItem String   
    *@return   return  the element {@odfLink text:dde-connection-decl}
    */
    public OdfDdeConnectionDeclElement createDdeConnectionDeclElement(String   name, String   ddeApplication, String   ddeTopic, String   ddeItem)
    {
        OdfDdeConnectionDeclElement  nDdeConnectionDecl = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDdeConnectionDeclElement.class);
        nDdeConnectionDecl.setName( name);
        nDdeConnectionDecl.setDdeApplication( ddeApplication);
        nDdeConnectionDecl.setDdeTopic( ddeTopic);
        nDdeConnectionDecl.setDdeItem( ddeItem);
        this.appendChild( nDdeConnectionDecl);
        return  nDdeConnectionDecl;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index-auto-mark-file}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink text:alphabetical-index-auto-mark-file}
    */
    public OdfAlphabeticalIndexAutoMarkFileElement createAlphabeticalIndexAutoMarkFileElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfAlphabeticalIndexAutoMarkFileElement  nAlphabeticalIndexAutoMarkFile = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexAutoMarkFileElement.class);
        nAlphabeticalIndexAutoMarkFile.setHref( href);
        this.appendChild( nAlphabeticalIndexAutoMarkFile);
        return  nAlphabeticalIndexAutoMarkFile;      
    }
    
    /**
    * Create child element {@odfLink text:h}.
    *
    *@param outlineLevel  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfPositiveInteger
    *@return   return  the element {@odfLink text:h}
    */
    public OdfHeadingElement createHeadingElement(org.odftoolkit.odfdom.dom.type.OdfPositiveInteger   outlineLevel)
    {
        OdfHeadingElement  nHeading = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfHeadingElement.class);
        nHeading.setOutlineLevel( outlineLevel);
        this.appendChild( nHeading);
        return  nHeading;      
    }
    
    /**
    * Create child element {@odfLink text:p}.
    *
    *@return   return  the element {@odfLink text:p}
    */
    public OdfParagraphElement createParagraphElement()
    {
        OdfParagraphElement  nParagraph = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfParagraphElement.class);
        this.appendChild( nParagraph);
        return  nParagraph;
    }                   
               
    /**
    * Create child element {@odfLink text:list}.
    *
    *@return   return  the element {@odfLink text:list}
    */
    public OdfListElement createListElement()
    {
        OdfListElement  nList = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfListElement.class);
        this.appendChild( nList);
        return  nList;
    }                   
               
    /**
    * Create child element {@odfLink table:table}.
    *
    *@return   return  the element {@odfLink table:table}
    */
    public OdfTableElement createTableElement()
    {
        OdfTableElement  nTable = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableElement.class);
        this.appendChild( nTable);
        return  nTable;
    }                   
               
    /**
    * Create child element {@odfLink text:section}.
    *
    *@param name String   
    *@param display     the attribute's type is OdfSectionDisplayType, see {@attributeName  text:section-display} at specification
    *@return   return  the element {@odfLink text:section}
    */
    public OdfSectionElement createSectionElement(String   name, OdfSectionDisplayType   display)
    {
        OdfSectionElement  nSection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSectionElement.class);
        nSection.setName( name);
        nSection.setDisplay( display);
        this.appendChild( nSection);
        return  nSection;      
    }
    
    /**
    * Create child element {@odfLink text:section}.
    *
    *@param display   the attribute's type is OdfSectionDisplayType, see {@attributeName  text:section-display} at specification
    *@param condition String   
    *@param name String   
    *@return   return  the element {@odfLink text:section}
    */
    public OdfSectionElement createSectionElement(OdfSectionDisplayType   display, String   condition, String   name)
    {
        OdfSectionElement  nSection = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSectionElement.class);
        nSection.setDisplay( display);
        nSection.setCondition( condition);
        nSection.setName( name);
        this.appendChild( nSection);
        return  nSection;      
    }
    
    /**
    * Create child element {@odfLink text:table-of-content}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:table-of-content}
    */
    public OdfTableOfContentElement createTableOfContentElement(String   name)
    {
        OdfTableOfContentElement  nTableOfContent = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableOfContentElement.class);
        nTableOfContent.setName( name);
        this.appendChild( nTableOfContent);
        return  nTableOfContent;      
    }
    
    /**
    * Create child element {@odfLink text:illustration-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:illustration-index}
    */
    public OdfIllustrationIndexElement createIllustrationIndexElement(String   name)
    {
        OdfIllustrationIndexElement  nIllustrationIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIllustrationIndexElement.class);
        nIllustrationIndex.setName( name);
        this.appendChild( nIllustrationIndex);
        return  nIllustrationIndex;      
    }
    
    /**
    * Create child element {@odfLink text:table-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:table-index}
    */
    public OdfTableIndexElement createTableIndexElement(String   name)
    {
        OdfTableIndexElement  nTableIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfTableIndexElement.class);
        nTableIndex.setName( name);
        this.appendChild( nTableIndex);
        return  nTableIndex;      
    }
    
    /**
    * Create child element {@odfLink text:object-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:object-index}
    */
    public OdfObjectIndexElement createObjectIndexElement(String   name)
    {
        OdfObjectIndexElement  nObjectIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfObjectIndexElement.class);
        nObjectIndex.setName( name);
        this.appendChild( nObjectIndex);
        return  nObjectIndex;      
    }
    
    /**
    * Create child element {@odfLink text:user-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:user-index}
    */
    public OdfUserIndexElement createUserIndexElement(String   name)
    {
        OdfUserIndexElement  nUserIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfUserIndexElement.class);
        nUserIndex.setName( name);
        this.appendChild( nUserIndex);
        return  nUserIndex;      
    }
    
    /**
    * Create child element {@odfLink text:alphabetical-index}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:alphabetical-index}
    */
    public OdfAlphabeticalIndexElement createAlphabeticalIndexElement(String   name)
    {
        OdfAlphabeticalIndexElement  nAlphabeticalIndex = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfAlphabeticalIndexElement.class);
        nAlphabeticalIndex.setName( name);
        this.appendChild( nAlphabeticalIndex);
        return  nAlphabeticalIndex;      
    }
    
    /**
    * Create child element {@odfLink text:bibliography}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:bibliography}
    */
    public OdfBibliographyElement createBibliographyElement(String   name)
    {
        OdfBibliographyElement  nBibliography = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBibliographyElement.class);
        nBibliography.setName( name);
        this.appendChild( nBibliography);
        return  nBibliography;      
    }
    
    /**
    * Create child element {@odfLink text:index-title}.
    *
    *@param name String   
    *@return   return  the element {@odfLink text:index-title}
    */
    public OdfIndexTitleElement createIndexTitleElement(String   name)
    {
        OdfIndexTitleElement  nIndexTitle = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfIndexTitleElement.class);
        nIndexTitle.setName( name);
        this.appendChild( nIndexTitle);
        return  nIndexTitle;      
    }
    
    /**
    * Create child element {@odfLink style:region-left}.
    *
    *@return   return  the element {@odfLink style:region-left}
    */
    public OdfRegionLeftElement createRegionLeftElement()
    {
        OdfRegionLeftElement  nRegionLeft = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegionLeftElement.class);
        this.appendChild( nRegionLeft);
        return  nRegionLeft;
    }                   
               
    /**
    * Create child element {@odfLink style:region-center}.
    *
    *@return   return  the element {@odfLink style:region-center}
    */
    public OdfRegionCenterElement createRegionCenterElement()
    {
        OdfRegionCenterElement  nRegionCenter = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegionCenterElement.class);
        this.appendChild( nRegionCenter);
        return  nRegionCenter;
    }                   
               
    /**
    * Create child element {@odfLink style:region-right}.
    *
    *@return   return  the element {@odfLink style:region-right}
    */
    public OdfRegionRightElement createRegionRightElement()
    {
        OdfRegionRightElement  nRegionRight = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfRegionRightElement.class);
        this.appendChild( nRegionRight);
        return  nRegionRight;
    }                   
               
}
