/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

import org.odftoolkit.odfdom.dom.element.office.OdfBinaryDataElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:header-footer-properties}.
 *
 */
public abstract class OdfHeaderFooterPropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "header-footer-properties" );

    /**
     * Create the instance of OdfHeaderFooterPropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfHeaderFooterPropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:header-footer-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty Height = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.SVG, "height"));
    public final static OdfStyleProperty MinHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "min-height"));
    public final static OdfStyleProperty MarginLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "margin-left"));
    public final static OdfStyleProperty MarginRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "margin-right"));
    public final static OdfStyleProperty MarginTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "margin-top"));
    public final static OdfStyleProperty MarginBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "margin-bottom"));
    public final static OdfStyleProperty Margin = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "margin"));
    public final static OdfStyleProperty Border = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "border"));
    public final static OdfStyleProperty BorderTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "border-top"));
    public final static OdfStyleProperty BorderBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "border-bottom"));
    public final static OdfStyleProperty BorderLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "border-left"));
    public final static OdfStyleProperty BorderRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "border-right"));
    public final static OdfStyleProperty BorderLineWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width"));
    public final static OdfStyleProperty BorderLineWidthTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-top"));
    public final static OdfStyleProperty BorderLineWidthBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-bottom"));
    public final static OdfStyleProperty BorderLineWidthLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-left"));
    public final static OdfStyleProperty BorderLineWidthRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.STYLE, "border-line-width-right"));
    public final static OdfStyleProperty Padding = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "padding"));
    public final static OdfStyleProperty PaddingTop = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "padding-top"));
    public final static OdfStyleProperty PaddingBottom = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "padding-bottom"));
    public final static OdfStyleProperty PaddingLeft = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "padding-left"));
    public final static OdfStyleProperty PaddingRight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "padding-right"));
    public final static OdfStyleProperty BackgroundColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.FO, "background-color"));
    public final static OdfStyleProperty Shadow = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.STYLE, "shadow"));
    public final static OdfStyleProperty DynamicSpacing = 
        OdfStyleProperty.get(OdfStylePropertiesSet.HeaderFooterProperties, OdfName.get(OdfNamespace.STYLE, "dynamic-spacing"));

    /**
    * Create child element {@odfLink office:binary-data}.
    *
    *@return   return  the element {@odfLink office:binary-data}
    */
    public OdfBinaryDataElement createBinaryDataElement()
    {
        OdfBinaryDataElement  nBinaryData = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBinaryDataElement.class);
        this.appendChild( nBinaryData);
        return  nBinaryData;
    }                   
               
}
