/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import org.odftoolkit.odfdom.dom.type.style.OdfLineStyleType;
import org.odftoolkit.odfdom.dom.type.style.OdfAdjustmentType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:footnote-sep}.
 *
 */
public abstract class OdfFootnoteSepElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "footnote-sep" );

    /**
     * Create the instance of OdfFootnoteSepElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFootnoteSepElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:footnote-sep}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }


    /**
     * Get value of attribute {@attributeName style:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:rel-width}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getRelWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-width" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:rel-width}.
     *
     *@param  relWidth    the attribute's type is OdfPercent
     */ 
     public void setRelWidth( OdfPercent relWidth )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-width" ), relWidth.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:color}.
     *
     *@return return the attribute which type is String
     */
    public String getColor()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "color" ) );
    }

    /**
     * Set value of attribute {@attributeName style:color}.
     *
     *@param  color    the attribute's type is String
     */ 
     public void setColor( String color )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "color" ), color );
    }

    /**
     * Get value of attribute {@attributeName style:line-style}.
     *
     *@return return the attribute which type is OdfLineStyleType
     */
    public OdfLineStyleType getLineStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "line-style" ) );
        return OdfLineStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:line-style}.
     *
     *@param  lineStyle    the attribute's type is OdfLineStyleType
     */ 
     public void setLineStyle( OdfLineStyleType lineStyle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "line-style" ), lineStyle.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:adjustment}.
     *
     *@return return the attribute which type is OdfAdjustmentType
     */
    public OdfAdjustmentType getAdjustment()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "adjustment" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "left";
        }

        return OdfAdjustmentType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:adjustment}.
     *
     *@param  adjustment    the attribute's type is OdfAdjustmentType
     */ 
     public void setAdjustment( OdfAdjustmentType adjustment )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "adjustment" ), adjustment.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:distance-before-sep}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDistanceBeforeSep()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "distance-before-sep" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:distance-before-sep}.
     *
     *@param  distanceBeforeSep    the attribute's type is OdfLength
     */ 
     public void setDistanceBeforeSep( OdfLength distanceBeforeSep )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "distance-before-sep" ), distanceBeforeSep.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:distance-after-sep}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getDistanceAfterSep()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "distance-after-sep" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:distance-after-sep}.
     *
     *@param  distanceAfterSep    the attribute's type is OdfLength
     */ 
     public void setDistanceAfterSep( OdfLength distanceAfterSep )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "distance-after-sep" ), distanceAfterSep.toString() );
    }

}
