/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.svg.OdfFontStyleType;
import org.odftoolkit.odfdom.dom.type.svg.OdfFontVariantType;
import org.odftoolkit.odfdom.dom.type.svg.OdfFontWeightType;
import org.odftoolkit.odfdom.dom.type.svg.OdfFontStretchType;
import org.odftoolkit.odfdom.dom.type.style.OdfFontFamilyGenericType;
import org.odftoolkit.odfdom.dom.type.style.OdfFontPitchType;

import org.odftoolkit.odfdom.dom.element.svg.OdfFontFaceSrcElement;
import org.odftoolkit.odfdom.dom.element.svg.OdfDefinitionSrcElement;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:font-face}.
 *
 */
public abstract class OdfFontFaceElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "font-face" );

    /**
     * Create the instance of OdfFontFaceElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfFontFaceElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:font-face}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfFontFaceElement}
     *
     *@param name  The mandatory attribute {@attributeName  style:name}" 
     *
     */
    public void init(String name)
    {
        setName( name );
    }

    /**
     * Get value of attribute {@attributeName svg:font-family}.
     *
     *@return return the attribute which type is String
     */
    public String getFontFamily()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-family" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:font-family}.
     *
     *@param  fontFamily    the attribute's type is String
     */ 
     public void setFontFamily( String fontFamily )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-family" ), fontFamily );
    }

    /**
     * Get value of attribute {@attributeName svg:font-style}.
     *
     *@return return the attribute which type is OdfFontStyleType
     */
    public OdfFontStyleType getFontStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-style" ) );
        return OdfFontStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:font-style}.
     *
     *@param  fontStyle    the attribute's type is OdfFontStyleType
     */ 
     public void setFontStyle( OdfFontStyleType fontStyle )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-style" ), fontStyle.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:font-variant}.
     *
     *@return return the attribute which type is OdfFontVariantType
     */
    public OdfFontVariantType getFontVariant()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-variant" ) );
        return OdfFontVariantType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:font-variant}.
     *
     *@param  fontVariant    the attribute's type is OdfFontVariantType
     */ 
     public void setFontVariant( OdfFontVariantType fontVariant )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-variant" ), fontVariant.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:font-weight}.
     *
     *@return return the attribute which type is OdfFontWeightType
     */
    public OdfFontWeightType getFontWeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-weight" ) );
        return OdfFontWeightType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:font-weight}.
     *
     *@param  fontWeight    the attribute's type is OdfFontWeightType
     */ 
     public void setFontWeight( OdfFontWeightType fontWeight )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-weight" ), fontWeight.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:font-stretch}.
     *
     *@return return the attribute which type is OdfFontStretchType
     */
    public OdfFontStretchType getFontStretch()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-stretch" ) );
        return OdfFontStretchType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:font-stretch}.
     *
     *@param  fontStretch    the attribute's type is OdfFontStretchType
     */ 
     public void setFontStretch( OdfFontStretchType fontStretch )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-stretch" ), fontStretch.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:font-size}.
     *
     *@return return the attribute which type is String
     */
    public String getFontSize()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-size" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:font-size}.
     *
     *@param  fontSize    the attribute's type is String
     */ 
     public void setFontSize( String fontSize )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "font-size" ), fontSize );
    }

    /**
     * Get value of attribute {@attributeName svg:unicode-range}.
     *
     *@return return the attribute which type is String
     */
    public String getUnicodeRange()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "unicode-range" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:unicode-range}.
     *
     *@param  unicodeRange    the attribute's type is String
     */ 
     public void setUnicodeRange( String unicodeRange )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "unicode-range" ), unicodeRange );
    }

    /**
     * Get value of attribute {@attributeName svg:units-per-em}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getUnitsPerEm()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "units-per-em" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:units-per-em}.
     *
     *@param  unitsPerEm    the attribute's type is Integer
     */ 
     public void setUnitsPerEm( Integer unitsPerEm )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "units-per-em" ), unitsPerEm.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:panose-1}.
     *
     *@return return the attribute which type is String
     */
    public String getPanose1()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "panose-1" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:panose-1}.
     *
     *@param  panose1    the attribute's type is String
     */ 
     public void setPanose1( String panose1 )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "panose-1" ), panose1 );
    }

    /**
     * Get value of attribute {@attributeName svg:stemv}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStemv()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "stemv" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:stemv}.
     *
     *@param  stemv    the attribute's type is Integer
     */ 
     public void setStemv( Integer stemv )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "stemv" ), stemv.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:stemh}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStemh()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "stemh" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:stemh}.
     *
     *@param  stemh    the attribute's type is Integer
     */ 
     public void setStemh( Integer stemh )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "stemh" ), stemh.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:slope}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getSlope()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "slope" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:slope}.
     *
     *@param  slope    the attribute's type is Integer
     */ 
     public void setSlope( Integer slope )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "slope" ), slope.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:cap-height}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getCapHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "cap-height" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:cap-height}.
     *
     *@param  capHeight    the attribute's type is Integer
     */ 
     public void setCapHeight( Integer capHeight )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "cap-height" ), capHeight.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:x-height}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getXHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "x-height" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:x-height}.
     *
     *@param  xHeight    the attribute's type is Integer
     */ 
     public void setXHeight( Integer xHeight )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "x-height" ), xHeight.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:accent-height}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getAccentHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "accent-height" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:accent-height}.
     *
     *@param  accentHeight    the attribute's type is Integer
     */ 
     public void setAccentHeight( Integer accentHeight )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "accent-height" ), accentHeight.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:ascent}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getAscent()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "ascent" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:ascent}.
     *
     *@param  ascent    the attribute's type is Integer
     */ 
     public void setAscent( Integer ascent )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "ascent" ), ascent.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:descent}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getDescent()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "descent" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:descent}.
     *
     *@param  descent    the attribute's type is Integer
     */ 
     public void setDescent( Integer descent )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "descent" ), descent.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:widths}.
     *
     *@return return the attribute which type is String
     */
    public String getWidths()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "widths" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:widths}.
     *
     *@param  widths    the attribute's type is String
     */ 
     public void setWidths( String widths )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "widths" ), widths );
    }

    /**
     * Get value of attribute {@attributeName svg:bbox}.
     *
     *@return return the attribute which type is String
     */
    public String getBbox()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SVG, "bbox" ) );
    }

    /**
     * Set value of attribute {@attributeName svg:bbox}.
     *
     *@param  bbox    the attribute's type is String
     */ 
     public void setBbox( String bbox )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "bbox" ), bbox );
    }

    /**
     * Get value of attribute {@attributeName svg:ideographic}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getIdeographic()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "ideographic" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:ideographic}.
     *
     *@param  ideographic    the attribute's type is Integer
     */ 
     public void setIdeographic( Integer ideographic )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "ideographic" ), ideographic.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:alphabetic}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getAlphabetic()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "alphabetic" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:alphabetic}.
     *
     *@param  alphabetic    the attribute's type is Integer
     */ 
     public void setAlphabetic( Integer alphabetic )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "alphabetic" ), alphabetic.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:mathematical}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getMathematical()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "mathematical" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:mathematical}.
     *
     *@param  mathematical    the attribute's type is Integer
     */ 
     public void setMathematical( Integer mathematical )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "mathematical" ), mathematical.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:hanging}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getHanging()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "hanging" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:hanging}.
     *
     *@param  hanging    the attribute's type is Integer
     */ 
     public void setHanging( Integer hanging )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "hanging" ), hanging.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:v-ideographic}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getVIdeographic()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-ideographic" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:v-ideographic}.
     *
     *@param  vIdeographic    the attribute's type is Integer
     */ 
     public void setVIdeographic( Integer vIdeographic )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-ideographic" ), vIdeographic.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:v-alphabetic}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getVAlphabetic()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-alphabetic" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:v-alphabetic}.
     *
     *@param  vAlphabetic    the attribute's type is Integer
     */ 
     public void setVAlphabetic( Integer vAlphabetic )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-alphabetic" ), vAlphabetic.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:v-mathematical}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getVMathematical()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-mathematical" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:v-mathematical}.
     *
     *@param  vMathematical    the attribute's type is Integer
     */ 
     public void setVMathematical( Integer vMathematical )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-mathematical" ), vMathematical.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:v-hanging}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getVHanging()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-hanging" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:v-hanging}.
     *
     *@param  vHanging    the attribute's type is Integer
     */ 
     public void setVHanging( Integer vHanging )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "v-hanging" ), vHanging.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:underline-position}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getUnderlinePosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "underline-position" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:underline-position}.
     *
     *@param  underlinePosition    the attribute's type is Integer
     */ 
     public void setUnderlinePosition( Integer underlinePosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "underline-position" ), underlinePosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:underline-thickness}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getUnderlineThickness()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "underline-thickness" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:underline-thickness}.
     *
     *@param  underlineThickness    the attribute's type is Integer
     */ 
     public void setUnderlineThickness( Integer underlineThickness )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "underline-thickness" ), underlineThickness.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:strikethrough-position}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStrikethroughPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "strikethrough-position" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:strikethrough-position}.
     *
     *@param  strikethroughPosition    the attribute's type is Integer
     */ 
     public void setStrikethroughPosition( Integer strikethroughPosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "strikethrough-position" ), strikethroughPosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:strikethrough-thickness}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getStrikethroughThickness()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "strikethrough-thickness" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:strikethrough-thickness}.
     *
     *@param  strikethroughThickness    the attribute's type is Integer
     */ 
     public void setStrikethroughThickness( Integer strikethroughThickness )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "strikethrough-thickness" ), strikethroughThickness.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:overline-position}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getOverlinePosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "overline-position" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:overline-position}.
     *
     *@param  overlinePosition    the attribute's type is Integer
     */ 
     public void setOverlinePosition( Integer overlinePosition )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "overline-position" ), overlinePosition.toString() );
    }

    /**
     * Get value of attribute {@attributeName svg:overline-thickness}.
     *
     *@return return the attribute which type is Integer
     */
    public Integer getOverlineThickness()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.SVG, "overline-thickness" ) );
        return Integer.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName svg:overline-thickness}.
     *
     *@param  overlineThickness    the attribute's type is Integer
     */ 
     public void setOverlineThickness( Integer overlineThickness )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.SVG, "overline-thickness" ), overlineThickness.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:name}.
     *
     *@return return the attribute which type is String
     */
    public String getName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ) );
    }

    /**
     * Set value of attribute {@attributeName style:name}.
     *
     *@param  name    the attribute's type is String
     */ 
     public void setName( String name )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "name" ), name );
    }

    /**
     * Get value of attribute {@attributeName style:font-adornments}.
     *
     *@return return the attribute which type is String
     */
    public String getFontAdornments()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-adornments" ) );
    }

    /**
     * Set value of attribute {@attributeName style:font-adornments}.
     *
     *@param  fontAdornments    the attribute's type is String
     */ 
     public void setFontAdornments( String fontAdornments )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-adornments" ), fontAdornments );
    }

    /**
     * Get value of attribute {@attributeName style:font-family-generic}.
     *
     *@return return the attribute which type is OdfFontFamilyGenericType
     */
    public OdfFontFamilyGenericType getFontFamilyGeneric()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-family-generic" ) );
        return OdfFontFamilyGenericType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:font-family-generic}.
     *
     *@param  fontFamilyGeneric    the attribute's type is OdfFontFamilyGenericType
     */ 
     public void setFontFamilyGeneric( OdfFontFamilyGenericType fontFamilyGeneric )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-family-generic" ), fontFamilyGeneric.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:font-pitch}.
     *
     *@return return the attribute which type is OdfFontPitchType
     */
    public OdfFontPitchType getFontPitch()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-pitch" ) );
        return OdfFontPitchType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:font-pitch}.
     *
     *@param  fontPitch    the attribute's type is OdfFontPitchType
     */ 
     public void setFontPitch( OdfFontPitchType fontPitch )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-pitch" ), fontPitch.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:font-charset}.
     *
     *@return return the attribute which type is String
     */
    public String getFontCharset()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-charset" ) );
    }

    /**
     * Set value of attribute {@attributeName style:font-charset}.
     *
     *@param  fontCharset    the attribute's type is String
     */ 
     public void setFontCharset( String fontCharset )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "font-charset" ), fontCharset );
    }

    /**
    * Create child element {@odfLink svg:font-face-src}.
    *
    *@return   return  the element {@odfLink svg:font-face-src}
    */
    public OdfFontFaceSrcElement createFontFaceSrcElement()
    {
        OdfFontFaceSrcElement  nFontFaceSrc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfFontFaceSrcElement.class);
        this.appendChild( nFontFaceSrc);
        return  nFontFaceSrc;
    }                   
               
    /**
    * Create child element {@odfLink svg:definition-src}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink svg:definition-src}
    */
    public OdfDefinitionSrcElement createDefinitionSrcElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfDefinitionSrcElement  nDefinitionSrc = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfDefinitionSrcElement.class);
        nDefinitionSrc.setHref( href);
        this.appendChild( nDefinitionSrc);
        return  nDefinitionSrc;      
    }
    
}
