/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfStylePropertiesBase;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;

import org.odftoolkit.odfdom.dom.element.presentation.OdfSoundElement;
import java.net.URI;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:drawing-page-properties}.
 *
 */
public abstract class OdfDrawingPagePropertiesElement extends OdfStylePropertiesBase
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "drawing-page-properties" );

    /**
     * Create the instance of OdfDrawingPagePropertiesElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfDrawingPagePropertiesElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:drawing-page-properties}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    public final static OdfStyleProperty Fill = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill"));
    public final static OdfStyleProperty FillColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-color"));
    public final static OdfStyleProperty SecondaryFillColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "secondary-fill-color"));
    public final static OdfStyleProperty FillGradientName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-gradient-name"));
    public final static OdfStyleProperty GradientStepCount = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "gradient-step-count"));
    public final static OdfStyleProperty FillHatchName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-hatch-name"));
    public final static OdfStyleProperty FillHatchSolid = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-hatch-solid"));
    public final static OdfStyleProperty FillImageName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-image-name"));
    public final static OdfStyleProperty Repeat = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.STYLE, "repeat"));
    public final static OdfStyleProperty FillImageWidth = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-image-width"));
    public final static OdfStyleProperty FillImageHeight = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-image-height"));
    public final static OdfStyleProperty FillImageRefPointX = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-image-ref-point-x"));
    public final static OdfStyleProperty FillImageRefPointY = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-image-ref-point-y"));
    public final static OdfStyleProperty FillImageRefPoint = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "fill-image-ref-point"));
    public final static OdfStyleProperty TileRepeatOffset = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "tile-repeat-offset"));
    public final static OdfStyleProperty Opacity = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "opacity"));
    public final static OdfStyleProperty OpacityName = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "opacity-name"));
    public final static OdfStyleProperty FillRule = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.SVG, "fill-rule"));
    public final static OdfStyleProperty TransitionType = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "transition-type"));
    public final static OdfStyleProperty TransitionStyle = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "transition-style"));
    public final static OdfStyleProperty TransitionSpeed = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "transition-speed"));
    public final static OdfStyleProperty Subtype = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.SMIL, "subtype"));
    public final static OdfStyleProperty Direction = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.SMIL, "direction"));
    public final static OdfStyleProperty FadeColor = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.SMIL, "fadeColor"));
    public final static OdfStyleProperty Duration = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "duration"));
    public final static OdfStyleProperty Visibility = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "visibility"));
    public final static OdfStyleProperty BackgroundSize = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.DRAW, "background-size"));
    public final static OdfStyleProperty BackgroundObjectsVisible = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "background-objects-visible"));
    public final static OdfStyleProperty BackgroundVisible = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "background-visible"));
    public final static OdfStyleProperty DisplayHeader = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "display-header"));
    public final static OdfStyleProperty DisplayFooter = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "display-footer"));
    public final static OdfStyleProperty DisplayPageNumber = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "display-page-number"));
    public final static OdfStyleProperty DisplayDateTime = 
        OdfStyleProperty.get(OdfStylePropertiesSet.DrawingPageProperties, OdfName.get(OdfNamespace.PRESENTATION, "display-date-time"));

    /**
    * Create child element {@odfLink presentation:sound}.
    *
    *@param href    the attribute's type is URI
    *@return   return  the element {@odfLink presentation:sound}
    */
    public OdfSoundElement createSoundElement(org.odftoolkit.odfdom.dom.type.OdfAnyURI   href)
    {
        OdfSoundElement  nSound = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfSoundElement.class);
        nSound.setHref( href);
        this.appendChild( nSound);
        return  nSound;      
    }
    
}
