/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfPositiveInteger;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:columns}.
 *
 */
public abstract class OdfColumnsElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "columns" );

    /**
     * Create the instance of OdfColumnsElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfColumnsElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:columns}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfColumnsElement}
     *
     *@param columnCount  The mandatory attribute {@attributeName  fo:column-count}" 
     *
     */
    public void init(OdfPositiveInteger columnCount)
    {
        setColumnCount( columnCount );
    }

    /**
     * Get value of attribute {@attributeName fo:column-count}.
     *
     *@return return the attribute which type is OdfPositiveInteger
     */
    public OdfPositiveInteger getColumnCount()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "column-count" ) );
        return OdfPositiveInteger.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:column-count}.
     *
     *@param  columnCount    the attribute's type is OdfPositiveInteger
     */ 
     public void setColumnCount( OdfPositiveInteger columnCount )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "column-count" ), columnCount.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:column-gap}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getColumnGap()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "column-gap" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:column-gap}.
     *
     *@param  columnGap    the attribute's type is OdfLength
     */ 
     public void setColumnGap( OdfLength columnGap )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "column-gap" ), columnGap.toString() );
    }

    /**
    * Create child element {@odfLink style:column-sep}.
    *
    *@param width  the attribute's type is org.odftoolkit.odfdom.dom.type.OdfLength
    *@return   return  the element {@odfLink style:column-sep}
    */
    public OdfColumnSepElement createColumnSepElement(org.odftoolkit.odfdom.dom.type.OdfLength   width)
    {
        OdfColumnSepElement  nColumnSep = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnSepElement.class);
        nColumnSep.setWidth( width);
        this.appendChild( nColumnSep);
        return  nColumnSep;      
    }
    
    /**
    * Create child element {@odfLink style:column}.
    *
    *@param relWidth String   
    *@return   return  the element {@odfLink style:column}
    */
    public OdfColumnElement createColumnElement(String   relWidth)
    {
        OdfColumnElement  nColumn = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfColumnElement.class);
        nColumn.setRelWidth( relWidth);
        this.appendChild( nColumn);
        return  nColumn;      
    }
    
}
