/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.style.OdfStyleType;
import org.odftoolkit.odfdom.dom.type.OdfLength;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import org.odftoolkit.odfdom.dom.type.style.OdfVerticalAlignType;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:column-sep}.
 *
 */
public abstract class OdfColumnSepElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "column-sep" );

    /**
     * Create the instance of OdfColumnSepElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfColumnSepElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:column-sep}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfColumnSepElement}
     *
     *@param width  The mandatory attribute {@attributeName  style:width}" 
     *
     */
    public void init(OdfLength width)
    {
        setWidth( width );
    }

    /**
     * Get value of attribute {@attributeName style:style}.
     *
     *@return return the attribute which type is OdfStyleType
     */
    public OdfStyleType getStyle()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "style" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "solid";
        }

        return OdfStyleType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:style}.
     *
     *@param  style    the attribute's type is OdfStyleType
     */ 
     public void setStyle( OdfStyleType style )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "style" ), style.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:width}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getWidth()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "width" ) );
        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:width}.
     *
     *@param  width    the attribute's type is OdfLength
     */ 
     public void setWidth( OdfLength width )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "width" ), width.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:height}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getHeight()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "height" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "100%";
        }

        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:height}.
     *
     *@param  height    the attribute's type is OdfPercent
     */ 
     public void setHeight( OdfPercent height )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "height" ), height.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:vertical-align}.
     *
     *@return return the attribute which type is OdfVerticalAlignType
     */
    public OdfVerticalAlignType getVerticalAlign()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "vertical-align" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "top";
        }

        return OdfVerticalAlignType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:vertical-align}.
     *
     *@param  verticalAlign    the attribute's type is OdfVerticalAlignType
     */ 
     public void setVerticalAlign( OdfVerticalAlignType verticalAlign )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "vertical-align" ), verticalAlign.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:color}.
     *
     *@return return the attribute which type is String
     */
    public String getColor()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "color" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "#000000";
        }

        return String.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:color}.
     *
     *@param  color    the attribute's type is String
     */ 
     public void setColor( String color )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "color" ), color );
    }

}
