/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.OdfLength;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:column}.
 *
 */
public abstract class OdfColumnElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "column" );

    /**
     * Create the instance of OdfColumnElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfColumnElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:column}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfColumnElement}
     *
     *@param relWidth  The mandatory attribute {@attributeName  style:rel-width}" 
     *
     */
    public void init(String relWidth)
    {
        setRelWidth( relWidth );
    }

    /**
     * Get value of attribute {@attributeName style:rel-width}.
     *
     *@return return the attribute which type is String
     */
    public String getRelWidth()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-width" ) );
    }

    /**
     * Set value of attribute {@attributeName style:rel-width}.
     *
     *@param  relWidth    the attribute's type is String
     */ 
     public void setRelWidth( String relWidth )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "rel-width" ), relWidth );
    }

    /**
     * Get value of attribute {@attributeName fo:start-indent}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getStartIndent()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "start-indent" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0cm";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:start-indent}.
     *
     *@param  startIndent    the attribute's type is OdfLength
     */ 
     public void setStartIndent( OdfLength startIndent )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "start-indent" ), startIndent.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:end-indent}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getEndIndent()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "end-indent" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0cm";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:end-indent}.
     *
     *@param  endIndent    the attribute's type is OdfLength
     */ 
     public void setEndIndent( OdfLength endIndent )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "end-indent" ), endIndent.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:space-before}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getSpaceBefore()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "space-before" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0cm";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:space-before}.
     *
     *@param  spaceBefore    the attribute's type is OdfLength
     */ 
     public void setSpaceBefore( OdfLength spaceBefore )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "space-before" ), spaceBefore.toString() );
    }

    /**
     * Get value of attribute {@attributeName fo:space-after}.
     *
     *@return return the attribute which type is OdfLength
     */
    public OdfLength getSpaceAfter()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.FO, "space-after" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "0cm";
        }

        return OdfLength.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName fo:space-after}.
     *
     *@param  spaceAfter    the attribute's type is OdfLength
     */ 
     public void setSpaceAfter( OdfLength spaceAfter )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.FO, "space-after" ), spaceAfter.toString() );
    }

}
