/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.style;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import org.odftoolkit.odfdom.dom.type.style.OdfRepeatType;
import org.odftoolkit.odfdom.dom.type.style.OdfPositionType;
import org.odftoolkit.odfdom.dom.type.OdfPercent;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

import org.odftoolkit.odfdom.dom.element.office.OdfBinaryDataElement;

/**
 * DOM implementation of OpenDocument element  {@odfLink style:background-image}.
 *
 */
public abstract class OdfBackgroundImageElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.STYLE, "background-image" );

    /**
     * Create the instance of OdfBackgroundImageElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfBackgroundImageElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink style:background-image}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfBackgroundImageElement}
     *
     *@param href  The mandatory attribute {@attributeName  xlink:href}" 
     *
     */
    public void init(OdfAnyURI href)
    {
        setHref( href );
    }

    /**
     * Get value of attribute {@attributeName style:repeat}.
     *
     *@return return the attribute which type is OdfRepeatType
     */
    public OdfRepeatType getRepeat()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "repeat" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "repeat";
        }

        return OdfRepeatType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:repeat}.
     *
     *@param  repeat    the attribute's type is OdfRepeatType
     */ 
     public void setRepeat( OdfRepeatType repeat )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "repeat" ), repeat.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:position}.
     *
     *@return return the attribute which type is OdfPositionType
     */
    public OdfPositionType getPosition()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "position" ) );
        if( stringVal.length()==0 )
        {
            stringVal = "center";
        }

        return OdfPositionType.enumValueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName style:position}.
     *
     *@param  position    the attribute's type is OdfPositionType
     */ 
     public void setPosition( OdfPositionType position )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "position" ), position.toString() );
    }

    /**
     * Get value of attribute {@attributeName style:filter-name}.
     *
     *@return return the attribute which type is String
     */
    public String getFilterName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.STYLE, "filter-name" ) );
    }

    /**
     * Set value of attribute {@attributeName style:filter-name}.
     *
     *@param  filterName    the attribute's type is String
     */ 
     public void setFilterName( String filterName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.STYLE, "filter-name" ), filterName );
    }

    /**
     * Get value of attribute {@attributeName draw:opacity}.
     *
     *@return return the attribute which type is OdfPercent
     */
    public OdfPercent getOpacity()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.DRAW, "opacity" ) );
        return OdfPercent.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName draw:opacity}.
     *
     *@param  opacity    the attribute's type is OdfPercent
     */ 
     public void setOpacity( OdfPercent opacity )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.DRAW, "opacity" ), opacity.toString() );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "show" ), "embed" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onLoad" );
    }

    /**
    * Create child element {@odfLink office:binary-data}.
    *
    *@return   return  the element {@odfLink office:binary-data}
    */
    public OdfBinaryDataElement createBinaryDataElement()
    {
        OdfBinaryDataElement  nBinaryData = ((OdfFileDom)this.ownerDocument).createOdfElement(OdfBinaryDataElement.class);
        this.appendChild( nBinaryData);
        return  nBinaryData;
    }                   
               
}
