/************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER
 *
 * Copyright 2008 Sun Microsystems, Inc. All rights reserved.
 *
 * Use is subject to license terms.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at http://www.apache.org/licenses/LICENSE-2.0. You can also
 * obtain a copy of the License at http://odftoolkit.org/docs/license.txt
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ************************************************************************/

/*
 * This file is automatically generated.
 * Don't edit manually.
 */    

package org.odftoolkit.odfdom.dom.element.script;

import org.odftoolkit.odfdom.dom.OdfName;
import org.odftoolkit.odfdom.dom.OdfNamespace;
import org.odftoolkit.odfdom.doc.OdfFileDom;
import org.odftoolkit.odfdom.dom.element.OdfElement;
import java.net.URI;
import org.odftoolkit.odfdom.dom.type.OdfAnyURI;

;

/**
 * DOM implementation of OpenDocument element  {@odfLink script:event-listener}.
 *
 */
public abstract class OdfEventListenerElement extends OdfElement
{        
    public static final OdfName ELEMENT_NAME = OdfName.get( OdfNamespace.SCRIPT, "event-listener" );

    /**
     * Create the instance of OdfEventListenerElement 
     *
     *@param  aOwnerDoc     The type is OdfFileDom
     */
    public OdfEventListenerElement( OdfFileDom aOwnerDoc )
    {
        super( aOwnerDoc, ELEMENT_NAME );
    }

    /**
     * Get the element name 
     *
     *@return  return   the name of element {@odfLink script:event-listener}.
     */
    public OdfName getOdfName()
    {
        return ELEMENT_NAME;
    }

    /**
     * Initialization of the mandatory attributes of {@link  OdfEventListenerElement}
     *
     *@param eventName  The mandatory attribute {@attributeName  script:event-name}" 
     *@param language  The mandatory attribute {@attributeName  script:language}" 
     *@param macroName  The mandatory attribute {@attributeName  script:macro-name}" 
     *@param href  The mandatory attribute {@attributeName  xlink:href}" 
     *
     */
    public void init(String eventName, String language, String macroName, OdfAnyURI href)
    {
        setEventName( eventName );
        setLanguage( language );
        setMacroName( macroName );
        setHref( href );
    }

    /**
     * Get value of attribute {@attributeName script:event-name}.
     *
     *@return return the attribute which type is String
     */
    public String getEventName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "event-name" ) );
    }

    /**
     * Set value of attribute {@attributeName script:event-name}.
     *
     *@param  eventName    the attribute's type is String
     */ 
     public void setEventName( String eventName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "event-name" ), eventName );
    }

    /**
     * Get value of attribute {@attributeName script:language}.
     *
     *@return return the attribute which type is String
     */
    public String getLanguage()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "language" ) );
    }

    /**
     * Set value of attribute {@attributeName script:language}.
     *
     *@param  language    the attribute's type is String
     */ 
     public void setLanguage( String language )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "language" ), language );
    }

    /**
     * Get value of attribute {@attributeName script:macro-name}.
     *
     *@return return the attribute which type is String
     */
    public String getMacroName()
    {
        return getOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "macro-name" ) );
    }

    /**
     * Set value of attribute {@attributeName script:macro-name}.
     *
     *@param  macroName    the attribute's type is String
     */ 
     public void setMacroName( String macroName )
    {
        setOdfAttribute( OdfName.get( OdfNamespace.SCRIPT, "macro-name" ), macroName );
    }

    /**
     * Get value of attribute {@attributeName xlink:href}.
     *
     *@return return the attribute which type is OdfAnyURI
     */
    public OdfAnyURI getHref()
    {                    
        String stringVal = getOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ) );
        return OdfAnyURI.valueOf( stringVal);
    }

    /**
     * Set value of attribute {@attributeName xlink:href}.
     *
     *@param  href    the attribute's type is OdfAnyURI
     */ 
     public void setHref( OdfAnyURI href )
    {                    
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "href" ), href.toString() );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "type" ), "simple" );
        setOdfAttribute( OdfName.get( OdfNamespace.XLINK, "actuate" ), "onRequest" );
    }

}
